package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.PcsBuyerCond;
import com.thebeastshop.pegasus.merchandise.model.PcsBusinessCategoryPermission;
import com.thebeastshop.pegasus.merchandise.model.PcsBuyerInfo;
import com.thebeastshop.pegasus.merchandise.model.PcsPurchaseCategoryPermission;
import com.thebeastshop.pegasus.merchandise.vo.PcsBuyerInfoVO;
import com.thebeastshop.pegasus.merchandise.vo.UserInfo;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-08-30
 */
public interface PcsBuyerDomain extends BaseDomain<PcsBuyerInfoVO, PcsBuyerInfo> {

    /**
     * 根据id获取采购详情
     * @return
     */
    PcsBuyerInfoVO getBuyerInfoById(Long id);

    /**
     * 获取所有采购员信息
     * @return
     */
    List<PcsBuyerInfoVO> getAllBuyers();

    /**
     * 采购员id与姓名对应列表
     * @return
     */
    List<Map<String,String>> getAllBuyerInfos();

    /**
     * 条件查询采购员信息
     * @param cond
     * @return
     */
    List<PcsBuyerInfo> getBuyerByCond(PcsBuyerCond cond);

    /**
     * 新建采购员
     * @param buyerInfo
     * @return
     */
    @Transactional
    Boolean newBuyer(PcsBuyerInfo buyerInfo);

    /**
     * 更新采购员信息
     * @param buyer
     * @return
     */
    @Transactional
    Boolean updateBuyerInfo(PcsBuyerInfo buyer);

    UserInfo findCategoryManagerByBuyer(Integer buyerId);
    
    /**
     * 采购分类权限绑定
     * @param purchaseCategoryPermission
     * @return
     */
    Integer addPurchaseCategoryPermission(PcsPurchaseCategoryPermission purchaseCategoryPermission);
    
    /**
     * 商业分类权限绑定
     * @param businessCategoryPermission
     * @return
     */
    Integer addBusinessCategoryPermission(PcsBusinessCategoryPermission businessCategoryPermission);

    int deletePurchaseCategoryPermByUserId(Integer userId);
    
    int deleteBusinessCategoryPermByUserId(Integer userId);
}
