package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.PcsBrandCond;
import com.thebeastshop.pegasus.merchandise.model.PcsBrand;
import com.thebeastshop.pegasus.merchandise.vo.PcsBrandVO;

import java.util.List;

/**
 * @author gongjun
 * @since 2016-08-30
 */
public interface PcsBrandDomain extends BaseDomain<PcsBrandVO, PcsBrand> {



    /**
     * 创建品牌
     *
     * @param record
     * @return
     */
    Long create(PcsBrand record, boolean saveDraft);

    /**
     * 更新品牌
     *
     * @param record
     * @return
     */
    boolean update(PcsBrand record, boolean saveDraft);

    /**
     * 根据主键查找品牌
     *
     * @param id
     * @return
     */
    PcsBrand findById(long id);

    /**
     * 根据条件查找品牌
     *
     * @param cond
     * @return
     */
    List<PcsBrandVO> findByCond(PcsBrandCond cond);

    /**
     * 根据名称查找品牌
     *
     * @param name
     * @return
     */
    List<PcsBrand> findByName(String name);

    /**
     * 根据id集合查找品牌
     *
     * @param ids
     * @return
     */
    List<PcsBrand> findByIds(List<Long> ids);

    /**
     * 品牌审核
     * @param id
     * @param isPass
     * @return
     */
    Boolean auditBrand(Long userId, long id, Boolean isPass, Integer type);

    /**
     * 记录品牌总数
     * @param cond
     * @return
     */
    long countByCond(PcsBrandCond cond);


}
