package com.thebeastshop.pegasus.merchandise.domain;

import com.thebeastshop.pegasus.merchandise.cond.OpProductCond;
import com.thebeastshop.pegasus.merchandise.model.OpProduct;
import com.thebeastshop.pegasus.merchandise.vo.OpProductExcelVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProductVO;
import com.thebeastshop.pegasus.merchandise.vo.OpTagVO;
import com.thebeastshop.pegasus.merchandise.vo.OpWatermarkVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:29
 */
public interface OpProductDomain extends BaseDomain<OpProductVO, OpProduct> {

    /**
     * 创建商品
     * @param prod
     * @return
     */
    boolean create(OpProductVO prod);

    /**
     * 创建组合商品
     * @param prod
     * @return
     */
    boolean createCombinedProduct(OpProductVO prod);

    /**
     * 编辑组合商品
     * @param prod
     * @return
     */
    boolean updateCombinedProduct(OpProductVO prod);

    boolean update(OpProductVO productVO);

    boolean updateProdAndSku(OpProductVO productVO);

    boolean deleteById(Long id);

    List<OpProductVO> findByCond(OpProductCond cond);

    List<OpProductVO> findBySkuCode(String skuCode);

    List<OpProductExcelVO> findExportListByCond(OpProductCond cond);

    List<OpProductVO> findByNameOrCode(String name);

    /**
     * 查询product关联spv信息
     * @param name
     * @return
     */
    List<OpProductVO> findProdWithSpvByNameOrCode(String name);

    OpProductVO findById(Long id);

    List<OpProductVO> findByIds(List<Long> ids);

    List<OpProductVO> findProdWithWatermarkByIds(List<Long> ids);

    List<OpProductVO> findProdWithTagByIds(List<Long> ids);

    List<Long> findProdWatermarkProdIdsByParams(Map<String,Object> params);

    List<Long> findProdTagProdIdsByParams(Map<String,Object> params);

    List<OpProduct> listProdMat(Map<String, Object> params);

    List<OpProductVO> findByIds(List<Long> ids, boolean withCategories);

    List<Long> findProductIdsByCampaignIds(List<Long> ids);

    List<Long> findProductIdsByCodes(List<String> codes);

    @Transactional
    int updateByExampleSelective(OpProductVO vo);

    OpProductVO findProductByCode(String code);
    List<OpWatermarkVO> queryWatermarksByProdId(Map<String,Object> params);
    List<OpTagVO> queryTagsByProdId(Map<String,Object> params);

    List<Map> listProdMat(OpProductCond cond);

    /**
     * 查找指定product id下是否存在指定的二级类目
     *
     * @param productId 商品编号
     *
     * @param categoryIds 二级类目编号集合
     *
     * @return
     */
    Boolean isExistsSpecialCategory(Long productId, List<Integer> categoryIds);

    /**
     * 查询组合产品根据产品id
     * @param productId
     * @return
     */
    OpProductVO findCombinedProductByProdId(Long productId);

    /**
     * 查找组合商品审核列表
     * @param cond
     * @return
     */
    List<OpProductVO> findCombinedProdAuditList(OpProductCond cond);

    /**
     * 审核组合商品
     * @param cond
     * @return
     */
    Boolean auditCombinedProdByProdId(OpProductCond cond);

    /**
     * 查找指定productId下是否只存在指定的二级类目
     * @param productId
     * @param categoryIds
     * @return
     */
    Boolean isOnlyExistsSpecialCategory(Long productId, List<Integer> categoryIds);

    /**
     * 根据商品编码获取商品编号
     * @param code
     * @return
     */
    Long getIdByCode(String code);

    /**
     * 根据商品编号获取商品编码
     * @param id
     * @return
     */
    String getCodeById(Long id);
}
