/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.client;

import com.thebeastshop.pegasus.merchandise.vo.PsSkuCustomizationVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;
import com.thebeastshop.pegasus.merchandise.vo.PsTagVO;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.elasticsearch.common.xcontent.XContentFactory.jsonBuilder;

/**
 * @author Roy.Chen
 * @version $Id: SKUClient.java, v 0.1 2015-08-05 17:13
 */
public class SkuESClient extends AbstractESClient<PsSkuVO> {

    public SkuESClient(String index, String type) {
        super(index, type);
    }

    public SkuESClient(String index, String type, String host, int port) {
        super(index, type, host, port);
    }

    @Override
    public PsSkuVO build(SearchHit hit, String chnCode) {
        return build(hit, chnCode, null);
    }

    @Override
    public PsSkuVO build(SearchHit hit, String chnCode, Long total) {
        PsSkuVO vo = new PsSkuVO();
        try {
            Map<String, Object> params = hit.getSource();
            vo.setSkuId((Integer) params.get("skuId") + 0L);
            vo.setSkuCode((String) params.get("skuCode"));
            vo.setSkuName((String) params.get("skuName"));
            vo.setSkuNameCN((String) params.get("skuNameCN"));
            vo.setSkuType((Integer) params.get("skuType"));
            vo.setIsMadeBySelf((Integer) params.get("isMadeBySelf"));
            vo.setIsImported((Integer) params.get("isImported"));
            vo.setSkuCustomMadeCode((String) params.get("customMadeCode"));
//        List<String> smallIconList = (List<String>) params.get("smallIconList");
//        List<String> largeIconList = (List<String>) params.get("largeIconList");
//        List<Map<String, String >> tagList = (List<Map<String, String>>) params.get("tagList");
//        if (CollectionUtils.isNotEmpty(smallIconList)) {
//            vo.setSmallIconList(smallIconList);
//        }
//        if (CollectionUtils.isNotEmpty(largeIconList)) {
//            vo.setLargeIconList(largeIconList);
//        }
//        if (CollectionUtils.isNotEmpty(tagList)) {
//            vo.setTagList(makeTagList(tagList));
//        }
            vo.setCombinedSkuRecipeCode((String) params.get("combinedSkuRecipeCode"));
            vo.setEan13((String) params.get("ean13"));
            vo.setBarcode((String) params.get("barcode"));
            vo.setCanPurchase((Integer) params.get("canPurchase"));
            vo.setCanRemark((Integer) params.get("canRemark"));
            vo.setIsJit((Integer) params.get("isJit"));
            vo.setSalesPrice(MapUtils.getDoubleValue(params, "salesPrice"));
            vo.setCategoryId((Integer) params.get("categoryId") + 0L);
            vo.setCategoryName((String) params.get("categoryName"));
            vo.setBrandId(MapUtils.getLongValue(params, "brandId"));
            vo.setBrandName((String) params.get("brandName"));
            vo.setBrandNameCN((String) params.get("brandNameCN"));
            if (params.get("brandCountryId") != null) {
                vo.setBrandCountryId((Integer) params.get("brandCountryId") + 0L);
            }
            if (params.get("brandCountryName") != null) {
                vo.setBrandCountryName((String) params.get("brandCountryName"));
            }
            vo.setCanCustomize(MapUtils.getInteger(params, "canCustomize"));
            if (vo.getCanCustomize() != null && vo.getCanCustomize() == 1) {
                vo.setCustomizationPrice(new BigDecimal(MapUtils.getString(params, "customizationPrice")));
                List<Map> customizationMapList = (List<Map>) params.get("customizationList");
                List<PsSkuCustomizationVO> customizations = new ArrayList<>();
                if (CollectionUtils.isNotEmpty(customizationMapList)) {
                    for (Map customizationMap : customizationMapList) {
                        PsSkuCustomizationVO customizationVO = new PsSkuCustomizationVO();
                        customizationVO.setId(MapUtils.getLong(customizationMap, "id"));
                        customizationVO.setImageUrl(MapUtils.getString(customizationMap, "imageUrl"));
                        customizationVO.setWordsLimit(MapUtils.getInteger(customizationMap, "wordsLimit"));
                        customizationVO.setDescription(MapUtils.getString(customizationMap, "description"));
                        customizations.add(customizationVO);
                    }
                    vo.setCustomizationList(customizations);
                }
            }
            vo.setSupplierId((Integer) params.get("supplierId") + 0L);
            vo.setSupplierName((String) params.get("supplierName"));
            vo.setSupplierNameCN((String) params.get("supplierNameCN"));
            vo.setPlaceOfOrigin((String) params.get("placeOfOrigin"));
            vo.setSkuCateName((String) params.get("skuCategoryName"));
            vo.setPointDeductPoint(new BigDecimal(MapUtils.getDoubleValue(params, "pointDeductPoint")).setScale(2, BigDecimal.ROUND_DOWN));
            vo.setPointDeductRule((Integer) params.get("pointDeductRule"));
            vo.setPointDuductPrice(new BigDecimal(MapUtils.getDoubleValue(params, "pointDuductPrice")).setScale(2, BigDecimal.ROUND_DOWN));
            vo.setCostPrice(new BigDecimal(MapUtils.getDoubleValue(params, "costPrice")).setScale(2, BigDecimal.ROUND_DOWN));
            vo.setCrossBorderFlag((Integer) params.get("crossBorderFlag"));
            if (params.get("clearanceWay") != null) {
                Integer bd = (Integer) params.get("clearanceWay");
                String db = bd + "";
                vo.setClearanceWay(Short.valueOf(db));
            }

            vo.setWeight((String) params.get("weight"));
            vo.setTaxNo((String) params.get("taxNo"));

            vo.setUpdateTime((String) params.get("updateTime"));
            vo.setWhetherConsignment((Integer) params.get("whetherConsignment"));
        } catch (Exception ex) {
            log.error("Build SKU Error: ", ex);
            throw ex;
        }
        return vo;
    }

    private List<PsTagVO> makeTagList(List<Map<String, String>> list) {
        List<PsTagVO> results = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            Map<String, String> map = list.get(i);
            String icon = map.get("icon");
            String text = map.get("text");
            PsTagVO tagVO = new PsTagVO();
            tagVO.setIcon(icon);
            tagVO.setText(text);
            results.add(tagVO);
        }
        return results;
    }

    private List<Map<String, String>> makeTagMapList(List<PsTagVO> voList) {
        if (voList == null || voList.isEmpty()) {
            return ListUtils.EMPTY_LIST;
        }
        List<Map<String, String>> mapList = new ArrayList<>();
        for (int i = 0; i < voList.size(); i++ ) {
            PsTagVO vo = voList.get(i);
            Map<String, String> map = new HashMap<>();
            map.put("icon", vo.getIcon());
            map.put("text", vo.getText());
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    public XContentBuilder getXContentBuilder(PsSkuVO vo) {
        try {
        XContentBuilder builder = jsonBuilder();

            builder.startObject()
                    //必须设置 方便删除更新
                    .field("id", vo.getSkuCode())
                    .field("skuId", vo.getSkuId())
                    .field("skuCode", vo.getSkuCode())
                    .field("skuName", vo.getSkuName())
                    .field("skuNameCN", vo.getSkuNameCN())
                    .field("skuType", vo.getSkuType())
                    .field("isMadeBySelf", vo.getIsMadeBySelf())
                    .field("isImported", vo.getIsImported())
                    //.field("smallIconList", vo.getSmallIconList())
                    //.field("largeIconList", vo.getLargeIconList())
                    //.field("tagList", makeTagMapList(vo.getTagList()))
                    .field("skuCustomMadeCode", avoidNull(vo.getSkuCustomMadeCode()))
                    .field("combinedSkuRecipeCode", avoidNull(vo.getCombinedSkuRecipeCode()))
                    .field("isSkuCustomMade", vo.getIsSkuCustomMade())
                    .field("isCombinedSkuRecipeCode", vo.getIsCombinedSkuRecipeCode())
                    .field("ean13", avoidNull(vo.getEan13()))
                    .field("barcode", avoidNull(vo.getBarcode()))
                    .field("canPurchase", vo.getCanPurchase())
                    .field("salesPrice", vo.getSalesPrice())
                    .field("categoryId", NumberUtil.avoidNull(vo.getCategoryId()))
                    .field("categoryName", avoidNull(vo.getCategoryName()))
                    .field("brandId", NumberUtil.avoidNull(vo.getBrandId()))
                    .field("brandName", vo.getBrandName())
                    .field("brandNameCN", vo.getBrandNameCN())
                    .field("brandCountryId", vo.getBrandCountryId())
                    .field("brandCountryName", vo.getBrandCountryName())
                    .field("skuCategoryName", vo.getSkuCateName())
                    .field("canRemark", vo.getCanRemark())
                    .field("placeOfOrigin", vo.getPlaceOfOrigin())
                    .field("isJit", vo.getIsJit())
                    .field("supplierId", NumberUtil.avoidNull(vo.getSupplierId()))
                    .field("supplierName", avoidNull(vo.getSupplierName()))
                    .field("supplierNameCN", avoidNull(vo.getSupplierNameCN()))
                    .field("pointDeductPoint", vo.getPointDeductPoint())
                    .field("pointDeductRule", vo.getPointDeductRule())
                    .field("pointDuductPrice", vo.getPointDuductPrice())
                    .field("costPrice", vo.getCostPrice())
                    .field("updateTime", vo.getUpdateTime())
                    .field("crossBorderFlag", vo.getCrossBorderFlag())
                    .field("clearanceWay", vo.getClearanceWay())
                    .field("weight", vo.getWeight())
                    .field("taxNo", vo.getTaxNo())
                    .endObject();
        return builder;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }



    private String avoidNull(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getPrimaryKeyName() {
        return "skuCode";
    }
}
