package com.thebeastshop.pegasus.merchandise.client;

import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import com.thebeastshop.pegasus.util.comm.EmptyUtil;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun
 * @since 2016-11-25
 */
public class CampaignESClient extends AbstractESClient<PsCampaignVO> {

    private static final Logger logger = LoggerFactory.getLogger(CampaignESClient.class);

    public CampaignESClient(String index, String type) {
        super(index, type);
    }

    public CampaignESClient(String index, String type, String host, int port) {
        super(index, type, host, port);
    }

    @Override
    public PsCampaignVO build(SearchHit hit, String chnCode) {
        Map<String, Object> params = hit.getSource();
        PsCampaignVO campaignVO = new PsCampaignVO();
        buildCampaign(params, campaignVO);
        return campaignVO;
    }

    @Override
    public PsCampaignVO build(SearchHit hit, String chnCode, Long total) {
        return build(hit, chnCode, null);
    }

    public void buildCampaign(Map params, PsCampaignVO psCampaignVO) {
        psCampaignVO.setId(Long.valueOf(String.valueOf(params.get("id"))));
        psCampaignVO.setState(MapUtils.getInteger(params, "state"));
        psCampaignVO.setName((String) params.get("name"));
        psCampaignVO.setTitle((String) params.get("title"));
        psCampaignVO.setDiscountTypeId((Integer) params.get("discountTypeId"));
        psCampaignVO.setDiscountTypeName((String) params.get("discountTypeName"));
        psCampaignVO.setProductScopeId((Integer) params.get("productScopeId"));
        psCampaignVO.setCrossBorderFlag(MapUtils.getInteger(params, "crossBorderFlag"));
        psCampaignVO.setAdvance((Integer) params.get("advance"));
        psCampaignVO.setAdvanceName((String) params.get("advanceName"));
        psCampaignVO.setAdvanceTitle((String) params.get("advanceTitle"));
        Date advanceStartTime = buildDateTime(params, "advanceStartTime");
        if(advanceStartTime != null) {
            // 因为ES时区问题，要加8小时
            psCampaignVO.setAdvanceStartTime(DateUtils.addHours(advanceStartTime, 8));
        }
        Date advanceEndTime = buildDateTime(params, "advanceEndTime");
        if(advanceEndTime != null) {
            // 因为ES时区问题，要加8小时
            psCampaignVO.setAdvanceEndTime(DateUtils.addHours(advanceEndTime, 8));
        }
        psCampaignVO.setAdvancePriceTitle((String) params.get("advancePriceTitle"));
        List<Integer> memberLevelIds = (List<Integer>) params.get("memberLevels");
        if (memberLevelIds == null) memberLevelIds = new ArrayList<>();
        psCampaignVO.setMemberLevels(memberLevelIds);

        List<Integer> accessWayIds = (List<Integer>) params.get("accessWayIds");
        if (accessWayIds == null) accessWayIds = new ArrayList<>();
        psCampaignVO.setAccessWayIds(accessWayIds);


        Date startTime = buildDateTime(params, "startTime");
        if (startTime != null) {
            // 因为ES时区问题，要加8小时
            psCampaignVO.setStartTime(DateUtils.addHours(startTime, 8));
        }


        Date expireTime = buildDateTime(params, "expireTime");
        if (expireTime != null) {
            // 因为ES时区问题，要加8小时
            psCampaignVO.setExpireTime(DateUtils.addHours(expireTime, 8));
        }

        List<Map> campaignSectionList = (List<Map>) params.get("campaignSections");
        if (EmptyUtil.isNotEmpty(campaignSectionList)) {
            List<PsCampaignSectionVO> campaignSections = new ArrayList<>();
            psCampaignVO.setCampaignSectionList(campaignSections);
            for (Map campaignSection : campaignSectionList) {
                PsCampaignSectionVO psCampaignSectionVO = new PsCampaignSectionVO();
                psCampaignSectionVO.setId(Long.valueOf(String.valueOf(campaignSection.get("id"))));
                psCampaignSectionVO.setCampaignId(Long.valueOf(String.valueOf(campaignSection.get("campaignId"))));
//                psCampaignSectionVO.setConditionType((Integer) campaignSection.get("conditionType"));
                psCampaignSectionVO.setConditionType(MapUtils.getInteger(campaignSection, "conditionType"));
                if (campaignSection.containsKey("line")) {
                    psCampaignSectionVO.setLine(new BigDecimal(MapUtils.getDouble(campaignSection, "line")));
                }
                if (campaignSection.containsKey("factor")) {
                    psCampaignSectionVO.setFactor(new BigDecimal(MapUtils.getDouble(campaignSection,"factor")));
                }
                if (campaignSection.containsKey("factorType")) {
                    psCampaignSectionVO.setFactorType(MapUtils.getInteger(campaignSection,"factorType"));
                }
                if (campaignSection.containsKey("ranking")) {
                    psCampaignSectionVO.setRanking(MapUtils.getDouble(campaignSection, "ranking"));
                }
                campaignSections.add(psCampaignSectionVO);

                List<Map> campaignSectionProductList = (List<Map>) campaignSection.get("sectionProducts");
                if (EmptyUtil.isNotEmpty(campaignSectionProductList)) {
                    List<PsCampaignSectionProductVO> campaignSectionProducts = new ArrayList<>();
                    psCampaignSectionVO.setCampaignSectionProducts(campaignSectionProducts);
                    for (Map campaignSectionProduct : campaignSectionProductList) {
                        PsCampaignSectionProductVO psCampaignSectionProductVO = new PsCampaignSectionProductVO();
                        psCampaignSectionProductVO.setId(Long.valueOf(String.valueOf(campaignSectionProduct.get("id"))));
                        psCampaignSectionProductVO.setCampaignId(psCampaignVO.getId());
                        psCampaignSectionProductVO.setCampaignSectionId(psCampaignSectionVO.getId());
                        psCampaignSectionProductVO.setProductId(Long.valueOf(String.valueOf(campaignSectionProduct.get("productId"))));
                        psCampaignSectionProductVO.setPricePrice(new BigDecimal(String.valueOf(campaignSectionProduct.get("productPrice"))));
                        psCampaignSectionProductVO.setPriceCount((Integer) campaignSectionProduct.get("productCount"));
                        campaignSectionProducts.add(psCampaignSectionProductVO);
                    }
                }
            }
        }
    }

    /**
     * 构建从ES取出来的日期
     * @param params
     * @param key
     * @return
     */
    private Date buildDateTime(Map params, String key) {
        Date date;
        try {
            String dateStr = MapUtils.getString(params, key);
            if(dateStr == null) {
                return null;
            }
            dateStr = StringUtils.replace(dateStr, "T", " ");
            date = DateUtil.parse(dateStr, "yyyy-MM-dd HH:mm:ss");
        } catch (Exception ex) {
            logger.error("构建从ES拿到的活动实体中的" + key + "字段转化时出错");
            return null;
        }
        return date;
    }

    @Override
    public XContentBuilder getXContentBuilder(PsCampaignVO vo) {
        return null;
    }

    @Override
    public String getPrimaryKeyName() {
        return "id";
    }
}
