/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.enums.IposProdStatusEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author Roy.Chen
 * @version $Id: OpProductVO.java, v 0.1 2015-08-18 11:55
 */
public class PsProductVO extends PsUpdateVO implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -3925814543271833236L;

    private String id;

    /**
     * 产品编码
     */
    private String code;

    /**
     * 是否组合
     */
    private Boolean combined;

    /**
     * SPV列表
     */
    private List<PsSpvVO> spvList;

    /**
     * 属性列表
     */
    private List<PsAttributeVO> attributeList;

    /**
     * 列表价
     */
    private BigDecimal listPrice;

    /**
     * 组合原价
     */
    private BigDecimal originalPrice;

    /**
     * 是否支持VIP折扣，1是0否
     */
    private Integer allowVipDiscount;

    /**
     * 是否支持生日折扣，1是0否
     */
    private Integer allowBdDiscount;

    /**
     * 是否支持代写卡片，0否1是
     */
    private Integer allowNoteCard;

    /**
     * 备货天数，默认0
     */
    private Integer prepareDays;

    /**
     * 可选择配送日期天数，0:尽快（不可选），n:n天内（默认n=7）
     */
    private Integer selectDeliveryDays;

    /**
     * 图片（列表）
     */
    private String picList;

    /**
     * 图片（详情）
     */
    private String picDetail;

    /**
     * 图片（缩略）
     */
    private String picThumb;

    /**
     * 图片,手机端,多张以’，‘ 分割
     */
    private String picDetailMul;

    /**
     * 产品名
     */
    private String name;

    /**
     * 产品中文名
     */
    private String nameCn;

    /**
     * SKU分类描述
     */
    private String skuCategoryDesc;

    /**
     * prod category , last update sku's category
     */
    private Long categoryId;

    /**
     * prod category , last update sku's category
     */
    private String categoryCode;

    /**
     * 是否海淘
     */
    private Integer crossBorderFlag;

    /**
     * 快递类型，1店送2联邦3顺丰
     */
    private Integer expressType;

    /**
     * 配送信息 区县  (自送)
     */
    private List<PsDeliveryVO> selfDeliveries = new ArrayList<>();

    /**
     * 动态内容
     */
    private List<PsDynmContentVO> dynmContents = new ArrayList<>();

    /**
     * 所有渠道编码
     */
    private List<String> chnSaleChnCodes = new ArrayList<>();

    /**
     * 上架渠道编码
     */
    private List<String> onShelfChnCodes = new ArrayList<>();

    /**
     * 下架渠道编码
     */
    private List<String> offShelfChnCodes = new ArrayList<>();

    /**
     * prod all skus
     */
    private List<String> skuCodes = new ArrayList<>();

    /**
     * 渠道Prod可售sku
     */
    private List<PsChnProdSaleSkuVO> chnCanSaleSKu = new ArrayList<>();

    /**
     * 渠道Prod 可见 sku
     */
    private List<PsChnProdSaleSkuVO> chnCanSeeSKu = new ArrayList<>();

    /**
     * 是否预售
     */
    private Boolean isPresale;

    /**
     * 是否预售
     */
    private Boolean hasPresale  = false;

    private PsPresaleSaleStockVO firstPresaleVO;

    /**
     * 优惠活动
     */
    private List<PsCampaignVO> campaignList = new ArrayList<>();

    /**
     * 开始销售时间
     */
    private Date saleStartDate;

    /**
     * 产品渠道绑定信息
     * map key:{channelCode,createTime}
     */
    private List<Map> channelProdInfo = new ArrayList<Map>();

    private Integer seq;

    private Integer sort1;

    private Integer sort2;

    private Date firstOnSaleTime;

    /**
     * 一句话描述
     */
    private String description;

    /**
     * 折扣价
     */
    private BigDecimal discountPrice;

    /**
     * 生日折扣价
     */
    private BigDecimal  bdDiscountPrice;

    /**
     * 列表页价格SpvId
     */
    private Long listPriceSpvId;

    /**
     * es总页数
     */
    private Long total;

    /**
     * 预告活动信息
     */
    private PsAdvanceCampaignVO psAdvanceCampaignVO;
    
    
    private Integer isMonthSend;//月送鲜花

    private String copywriter; //文案

    private Integer isDiscount;//是否特殊折扣

    private String video;//视频

    private String videoCover;//视频封面

    private List<String> analysis;

    private List<PsBrandVO> brands = new ArrayList<>();

    private List<PsLabelVO> labels = new ArrayList<>();

    private List<PsSkuAttributeVO> skuAttributes = new ArrayList<>();

    private Integer flowerMonProductionType; //月送类型

    private IposProdStatusEnum iposProdStatus; //ipos商品状态

    private Integer displayInCombinedArea; //组合搭配专区 1:展示 0:不展示

    public String getCopywriter() {
        return copywriter;
    }

    public void setCopywriter(String copywriter) {
        this.copywriter = copywriter;
    }

    public Integer getIsMonthSend() {
		return isMonthSend;
	}

	public void setIsMonthSend(Integer isMonthSend) {
		this.isMonthSend = isMonthSend;
	}

	public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }

    public List<PsSpvVO> getSpvList() {
        return spvList;
    }

    public void setSpvList(List<PsSpvVO> spvList) {
        this.spvList = spvList;
    }

    public List<PsAttributeVO> getAttributeList() {
        return attributeList;
    }

    public void setAttributeList(List<PsAttributeVO> attributeList) {
        this.attributeList = attributeList;
    }

    private List<PsCategoryVO> frontCategories;

    private List<PsChnStockVO> stocks;

    private List<String> smallIconList  = new ArrayList<String>();

    private List<String> largeIconList = new ArrayList<String>();

    private List<PsTagVO> psTags = new ArrayList<PsTagVO>();

    public Integer getSeq() {
        return seq;
    }

    public void setSeq(final Integer seq) {
        this.seq = seq;
    }

    public Integer getSort1() {
        return sort1;
    }

    public void setSort1(final Integer sort1) {
        this.sort1 = sort1;
    }

    public Integer getSort2() {
        return sort2;
    }

    public void setSort2(final Integer sort2) {
        this.sort2 = sort2;
    }

    public Date getFirstOnSaleTime() {
        return firstOnSaleTime;
    }

    public void setFirstOnSaleTime(final Date firstOnSaleTime) {
        this.firstOnSaleTime = firstOnSaleTime;
    }

    public Integer getExpressType() {
        return expressType;
    }

    public void setExpressType(final Integer expressType) {
        this.expressType = expressType;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(final Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(final String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public List<PsCategoryVO> getFrontCategories() {
        return frontCategories;
    }

    public void setFrontCategories(List<PsCategoryVO> frontCategories) {
        this.frontCategories = frontCategories;
    }

    public List<PsChnStockVO> getStocks() {
        return stocks;
    }

    public void setStocks(List<PsChnStockVO> stocks) {
        this.stocks = stocks;
    }

    public List<String> getSmallIconList() {
        return smallIconList;
    }

    public void setSmallIconList(List<String> smallIconList) {
        this.smallIconList = smallIconList;
    }

    public List<String> getLargeIconList() {
        return largeIconList;
    }

    public void setLargeIconList(List<String> largeIconList) {
        this.largeIconList = largeIconList;
    }

    public List<PsTagVO> getPsTags() {
        return psTags;
    }

    public void setPsTags(List<PsTagVO> psTags) {
        this.psTags = psTags;
    }

    public List<PsDeliveryVO> getSelfDeliveries() {
        return selfDeliveries;
    }

    public void setSelfDeliveries(final List<PsDeliveryVO> selfDeliveries) {
        this.selfDeliveries = selfDeliveries;
    }

    public List<PsChnProdSaleSkuVO> getChnCanSaleSKu() {
        return chnCanSaleSKu;
    }

    public void setChnCanSaleSKu(final List<PsChnProdSaleSkuVO> chnCanSaleSKu) {
        this.chnCanSaleSKu = chnCanSaleSKu;
    }

    public List<String> getChnSaleChnCodes() {
        return chnSaleChnCodes;
    }

    public void setChnSaleChnCodes(final List<String> chnSaleChnCodes) {
        this.chnSaleChnCodes = chnSaleChnCodes;
    }

    public List<String> getOnShelfChnCodes() {
        return onShelfChnCodes;
    }

    public void setOnShelfChnCodes(final List<String> onShelfChnCodes) {
        this.onShelfChnCodes = onShelfChnCodes;
    }

    public List<String> getOffShelfChnCodes() {
        return offShelfChnCodes;
    }

    public void setOffShelfChnCodes(final List<String> offShelfChnCodes) {
        this.offShelfChnCodes = offShelfChnCodes;
    }

    public List<PsDynmContentVO> getDynmContents() {
        return dynmContents;
    }

    public void setDynmContents(final List<PsDynmContentVO> dynmContents) {
        this.dynmContents = dynmContents;
    }

    public String getCode() {
        return code;
    }

    public void setCode(final String code) {
        this.code = code;
    }

    public BigDecimal getListPrice() {
        return listPrice;
    }

    public void setListPrice(final BigDecimal listPrice) {
        this.listPrice = listPrice;
    }

    public Integer getAllowVipDiscount() {
        return allowVipDiscount;
    }

    public void setAllowVipDiscount(final Integer allowVipDiscount) {
        this.allowVipDiscount = allowVipDiscount;
    }

    public Integer getAllowNoteCard() {
        return allowNoteCard;
    }

    public void setAllowNoteCard(final Integer allowNoteCard) {
        this.allowNoteCard = allowNoteCard;
    }

    public Integer getPrepareDays() {
        return prepareDays;
    }

    public void setPrepareDays(final Integer prepareDays) {
        this.prepareDays = prepareDays;
    }

    public Integer getSelectDeliveryDays() {
        return selectDeliveryDays;
    }

    public void setSelectDeliveryDays(final Integer selectDeliveryDays) {
        this.selectDeliveryDays = selectDeliveryDays;
    }

    public String getPicList() {
        return picList == null?"":picList;
    }

    public void setPicList(final String picList) {
        this.picList = picList;
    }

    public String getPicDetail() {
        return picDetail == null?"":picDetail;
    }

    public void setPicDetail(final String picDetail) {
        this.picDetail = picDetail;
    }

    public String getPicThumb() {
        return picThumb == null?"":picThumb;
    }

    public void setPicThumb(final String picThumb) {
        this.picThumb = picThumb;
    }

    public String getName() {
        return name == null?"":name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn == null?"":nameCn;
    }

    public void setNameCn(final String nameCn) {
        this.nameCn = nameCn;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(final List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getSkuCategoryDesc() {
        return skuCategoryDesc;
    }

    public void setSkuCategoryDesc(final String skuCategoryDesc) {
        this.skuCategoryDesc = skuCategoryDesc;
    }

    public List<PsChnProdSaleSkuVO> getChnCanSeeSKu() {
        return chnCanSeeSKu;
    }

    public void setChnCanSeeSKu(final List<PsChnProdSaleSkuVO> chnCanSeeSKu) {
        this.chnCanSeeSKu = chnCanSeeSKu;
    }

    public Boolean getPresale() {
        return isPresale;
    }

    public void setPresale(Boolean presale) {
        isPresale = presale;
    }

    public List<PsCampaignVO> getCampaignList() {
        return campaignList;
    }

    public void setCampaignList(List<PsCampaignVO> campaignList) {
        this.campaignList = campaignList;
    }

    public Date getSaleStartDate() {
        return saleStartDate;
    }

    public void setSaleStartDate(final Date saleStartDate) {
        this.saleStartDate = saleStartDate;
    }

    public List<Map> getChannelProdInfo() {
        return channelProdInfo;
    }

    public void setChannelProdInfo(List<Map> channelProdInfo) {
        this.channelProdInfo = channelProdInfo;
    }

    public String getPicDetailMul() {
        return picDetailMul;
    }

    public void setPicDetailMul(final String picDetailMul) {
        this.picDetailMul = picDetailMul;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public List<PsBrandVO> getBrands() {
        return brands;
    }

    public void setBrands(List<PsBrandVO> brands) {
        this.brands = brands;
    }

    public Long getListPriceSpvId() {
        return listPriceSpvId;
    }

    public void setListPriceSpvId(Long listPriceSpvId) {
        this.listPriceSpvId = listPriceSpvId;
    }

    public PsAdvanceCampaignVO getPsAdvanceCampaignVO() {
        return psAdvanceCampaignVO;
    }

    public void setPsAdvanceCampaignVO(PsAdvanceCampaignVO psAdvanceCampaignVO) {
        this.psAdvanceCampaignVO = psAdvanceCampaignVO;
    }

    public Integer getAllowBdDiscount() {
        return allowBdDiscount;
    }

    public void setAllowBdDiscount(Integer allowBdDiscount) {
        this.allowBdDiscount = allowBdDiscount;
    }

    public BigDecimal getBdDiscountPrice() {
        return bdDiscountPrice;
    }

    public void setBdDiscountPrice(BigDecimal bdDiscountPrice) {
        this.bdDiscountPrice = bdDiscountPrice;
    }

    public List<PsLabelVO> getLabels() {
        return labels;
    }

    public void setLabels(List<PsLabelVO> labels) {
        this.labels = labels;
    }

    public Integer getIsDiscount() {
        return isDiscount;
    }

    public void setIsDiscount(Integer isDiscount) {
        this.isDiscount = isDiscount;
    }

    public String getVideo() {
        return video;
    }

    public void setVideo(String video) {
        this.video = video;
    }

    public String getVideoCover() {
        return videoCover;
    }

    public void setVideoCover(String videoCover) {
        this.videoCover = videoCover;
    }

    public List<String> getAnalysis() {
        return analysis;
    }

    public void setAnalysis(List<String> analysis) {
        this.analysis = analysis;
    }

    public Boolean getHasPresale() {
        return hasPresale;
    }

    public void setHasPresale(Boolean hasPresale) {
        this.hasPresale = hasPresale;
    }

    public PsPresaleSaleStockVO getFirstPresaleVO(){
        if(CollectionUtils.isNotEmpty(spvList)){
            for(PsSpvVO spv:spvList){
                PsPresaleSaleStockVO presaleSaleVO = spv.getPsPresaleSaleStockVO();
                if(presaleSaleVO != null){
                    return presaleSaleVO;
                }
            }
        }
        return null;
    }

    /**
     * 获取渠道Prod下的可售sku列表
     * @param chnCode  渠道编码
     * @return
     */
    public List<String> getCanSaleSku(final String chnCode) {
        if (StringUtils.isBlank(chnCode)) {
            return Collections.emptyList();
        }

        for (final PsChnProdSaleSkuVO prodSaleSku : chnCanSaleSKu) {
            if (StringUtils.equals(prodSaleSku.getChnCode(), chnCode)) {
                final List<String> skus = new ArrayList<>();
                for (final String s : prodSaleSku.getCanSkus()) {
                    if (getSkuCodes().contains(s)) {
                        skus.add(s);
                    }
                }
//                prodSaleSku.getCanSkus().retainAll(getPromSkus());
//                return prodSaleSku.getCanSkus();
                return skus;
            }
        }

        return Collections.emptyList();
    }
    /**
     * 获取渠道Prod下的可见sku列表
     * @param chnCode  渠道编码
     * @return
     */
    public List<String> getCanSeeSku(final String chnCode) {
        if (StringUtils.isBlank(chnCode)) {
            return Collections.emptyList();
        }

        for (final PsChnProdSaleSkuVO prodSaleSku : chnCanSeeSKu) {
            if (StringUtils.equals(prodSaleSku.getChnCode(), chnCode)) {
                return prodSaleSku.getCanSkus();
            }
        }

        return Collections.emptyList();
    }

    public List<String> getPicDetailMuls(){
        if (StringUtils.isBlank(picDetailMul)) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(picDetailMul.split(","));
    }

    public List<PsSkuAttributeVO> getSkuAttributes() {
        return skuAttributes;
    }

    public void setSkuAttributes(List<PsSkuAttributeVO> skuAttributes) {
        this.skuAttributes = skuAttributes;
    }

    public Integer getFlowerMonProductionType() {
        return flowerMonProductionType;
    }

    public void setFlowerMonProductionType(Integer flowerMonProductionType) {
        this.flowerMonProductionType = flowerMonProductionType;
    }

    public IposProdStatusEnum getIposProdStatus() {
        return iposProdStatus;
    }

    public void setIposProdStatus(IposProdStatusEnum iposProdStatus) {
        this.iposProdStatus = iposProdStatus;
    }

    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }

    public Integer getDisplayInCombinedArea() {
        return displayInCombinedArea;
    }

    public void setDisplayInCombinedArea(Integer displayInCombinedArea) {
        this.displayInCombinedArea = displayInCombinedArea;
    }

    @Override
    public String toString() {
        return "PsProductVO{" +
                "id='" + id + '\'' +
                ", code='" + code + '\'' +
                ", combined=" + combined +
                ", spvList=" + spvList +
                ", attributeList=" + attributeList +
                ", listPrice=" + listPrice +
                ", allowVipDiscount=" + allowVipDiscount +
                ", allowNoteCard=" + allowNoteCard +
                ", prepareDays=" + prepareDays +
                ", selectDeliveryDays=" + selectDeliveryDays +
                ", picList='" + picList + '\'' +
                ", picDetail='" + picDetail + '\'' +
                ", picThumb='" + picThumb + '\'' +
                ", picDetailMul='" + picDetailMul + '\'' +
                ", name='" + name + '\'' +
                ", nameCn='" + nameCn + '\'' +
                ", skuCategoryDesc='" + skuCategoryDesc + '\'' +
                ", categoryId=" + categoryId +
                ", categoryCode='" + categoryCode + '\'' +
                ", crossBorderFlag=" + crossBorderFlag +
                ", expressType=" + expressType +
                ", selfDeliveries=" + selfDeliveries +
                ", dynmContents=" + dynmContents +
                ", chnSaleChnCodes=" + chnSaleChnCodes +
                ", onShelfChnCodes=" + onShelfChnCodes +
                ", offShelfChnCodes=" + offShelfChnCodes +
                ", skuCodes=" + skuCodes +
                ", chnCanSaleSKu=" + chnCanSaleSKu +
                ", chnCanSeeSKu=" + chnCanSeeSKu +
                ", isPresale=" + isPresale +
                ", campaignList=" + campaignList +
                ", saleStartDate=" + saleStartDate +
                ", channelProdInfo=" + channelProdInfo +
                ", seq=" + seq +
                ", sort1=" + sort1 +
                ", sort2=" + sort2 +
                ", firstOnSaleTime=" + firstOnSaleTime +
                ", description='" + description + '\'' +
                ", discountPrice=" + discountPrice +
                ", listPriceSpvId=" + listPriceSpvId +
                ", total=" + total +
                ", advanceCampaignVO=" + psAdvanceCampaignVO +
                ", brands=" + brands +
                ", frontCategories=" + frontCategories +
                ", stocks=" + stocks +
                ", smallIconList=" + smallIconList +
                ", largeIconList=" + largeIconList +
                ", psTags=" + psTags +
                '}';
    }
}






