package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.List;

/**
 * SKU通关方式
 */
public enum  PcsSkuClearanceWayEnum {
   BC(1, "BC"),
   PERSONAL(2, "个人"),
   COMMON(3, "一般贸易"),
   EXPRESS(4, "快件");

   private Integer val;

   private String desc;

  PcsSkuClearanceWayEnum(Integer val, String desc) {
    this.val = val;
    this.desc = desc;
  }
  public final static List<PcsSkuClearanceWayEnum> ALL = Arrays.asList(PcsSkuClearanceWayEnum.values());

  public  static Integer  isContainDesc(String desc) {
    for (PcsSkuClearanceWayEnum clearanceWayEnum : ALL) {
      if(clearanceWayEnum.desc.equals(desc)) {
        return clearanceWayEnum.val;
      }
    }
    return null;
  }

  public Integer getVal() {
    return val;
  }

  public String getDesc() {
    return desc;
  }
}
