/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.vo.PsBaseVO;
import com.thebeastshop.pegasus.merchandise.vo.PsCampaignSectionVO;
import java.util.Date;
import java.util.List;

public class PsCampaignVO
extends PsBaseVO {
    private Long id;
    private String name;
    private String title;
    private Integer state;
    private Integer productScopeId;
    private Integer discountTypeId;
    private String discountTypeName;
    private Integer crossBorderFlag;
    private List<Integer> accessWayIds;
    private List<Integer> memberLevels;
    private transient byte[] accessWayArray = new byte[10];
    private transient byte[] memberLevelArray = new byte[10];
    private List<PsCampaignSectionVO> campaignSectionList;
    private Integer cumulative;
    private Date createTime;
    private Date startTime;
    private Date expireTime;
    private Integer approvalState;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getProductScopeId() {
        return this.productScopeId;
    }

    public void setProductScopeId(Integer productScopeId) {
        this.productScopeId = productScopeId;
    }

    public Integer getDiscountTypeId() {
        return this.discountTypeId;
    }

    public void setDiscountTypeId(Integer discountTypeId) {
        this.discountTypeId = discountTypeId;
    }

    public String getDiscountTypeName() {
        return this.discountTypeName;
    }

    public void setDiscountTypeName(String discountTypeName) {
        this.discountTypeName = discountTypeName;
    }

    public Integer getCrossBorderFlag() {
        return this.crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public List<Integer> getAccessWayIds() {
        return this.accessWayIds;
    }

    public void setAccessWayIds(List<Integer> accessWayIds) {
        this.accessWayIds = accessWayIds;
        if (accessWayIds != null) {
            for (Integer index : accessWayIds) {
                if (index < 0 || index > 9) continue;
                this.accessWayArray[index.intValue()] = 1;
            }
        }
    }

    public List<Integer> getMemberLevels() {
        return this.memberLevels;
    }

    public void setMemberLevels(List<Integer> memberLevels) {
        this.memberLevels = memberLevels;
        if (memberLevels != null) {
            for (Integer index : memberLevels) {
                if (index < -1 || index > 8) continue;
                this.memberLevelArray[index.intValue() + 1] = 1;
            }
        }
    }

    public boolean match(int accessWay, int memberLevel, boolean crossBorderFlag) {
        Date now;
        if (accessWay > 9 || accessWay < 0 || memberLevel > 8 || memberLevel < -1) {
            return false;
        }
        if (this.state == null || this.state != 1) {
            return false;
        }
        if (this.startTime != null && this.expireTime != null && ((now = new Date()).before(this.startTime) || now.after(this.expireTime))) {
            return false;
        }
        if (this.crossBorderFlag != null && this.crossBorderFlag == 1 && !crossBorderFlag) {
            return false;
        }
        if ((this.crossBorderFlag == null || this.crossBorderFlag == 0) && crossBorderFlag) {
            return false;
        }
        if (this.accessWayArray[accessWay] == 0) {
            return false;
        }
        return this.memberLevelArray[memberLevel + 1] != 0;
    }

    public List<PsCampaignSectionVO> getCampaignSectionList() {
        return this.campaignSectionList;
    }

    public void setCampaignSectionList(List<PsCampaignSectionVO> campaignSectionList) {
        this.campaignSectionList = campaignSectionList;
    }

    public Integer getCumulative() {
        return this.cumulative;
    }

    public void setCumulative(Integer cumulative) {
        this.cumulative = cumulative;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getApprovalState() {
        return this.approvalState;
    }

    public void setApprovalState(Integer approvalState) {
        this.approvalState = approvalState;
    }
}

