package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.pegasus.merchandise.cond.OpProductCond;
import com.thebeastshop.pegasus.merchandise.vo.*;

import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:26
 */
public interface McOpProductService {
    @Transactional
    boolean update(OpProductVO productVO);
    OpProductVO findById(Long id);
    List<OpProductVO> findByIds(List<Long> ids);
    List<Long> findProductIdsByCampaignIds(List<Long> ids);   
    List<OpProductVO> findProdWithWatermarkByIds(List<Long> ids);
    List<OpProductVO> findProdWithTagByIds(List<Long> ids);
	List<Long> findProdWatermarkProdIdsByParams(Map<String, Object> params);
	List<Long> findProdTagProdIdsByParams(Map<String, Object> params);

    List<OpProductVO> listProdMat(Map<String, Object> params);
    PageQueryResp<OpProductVO> listProdMatByPage(Map<String, Object> params);

    @Transactional
    Long create(OpProductVO prod);

    @Transactional
    Long createCombinedProduct(OpProductVO prod);

    /**
     * 创建临时组合商品
     * @param prod
     * @return
     */
    @Transactional
    Long createCombinedProductTemp(OpProductVO prod);

    @Transactional
    Boolean updateCombinedProduct(OpProductVO prod);

    @Transactional
    boolean updateProdAndSku(OpProductVO productVO);

    @Transactional
    boolean deleteById(Long id);

    List<OpProductVO> findByCond(OpProductCond cond);

    List<OpProductVO> findAuditByCond(OpProductCond cond);

    List<OpProductVO> findBySkuCode(String skuCode);

    List<OpProductExcelVO> findExportListByCond(OpProductCond cond);

    List<OpProductVO> findByNameOrCode(String name);


    List<OpProductVO> findByIds(List<Long> ids, boolean withCategories);

    List<Long> findProductIdsByCodes(List<String> codes);

    List<OpProductVO> findProductIds();

    @Transactional
    int updateByExampleSelective(OpProductVO vo);

    /**
     * 通过prodcutCode 查询 product
     * @author lijing
     * @param code
     * @return
     */
    OpProductVO findProductByCode(String code);
    List<OpWatermarkVO> queryWatermarksByProdId(Map<String,Object> params);
    List<OpTagVO> queryTagsByProdId(Map<String,Object> params);

    List<Map> listProdMat(OpProductCond cond);


    /**
     * 查找指定product id下是否存在指定的二级类目
     *
     * @param productId   商品编号
     *
     * @param categoryIds 指定的二级类目编号
     *
     * @return
     */
    Boolean isExistsSpecialCategory(Long productId, List<Integer> categoryIds);

    /**
     * 查找指定productId下的sku是否只存在指定的二级类目
     * @param productId
     * @param categoryIds
     * @return
     */
    Boolean isOnlyExistsSpecialCategory(Long productId, List<Integer> categoryIds);


	Map getBatchUpdateMapByCode(String code);

    /**
     * 查询产品信息及spv
     * @return
     */
    List<OpProductVO> findProdWithSpvByNameOrCode(String arg0);

    /**
     * 查询组合商品根据商品id
     * @param prodId
     * @return
     */
    OpProductVO findCombinedProdbyProdId(Long prodId);

    /**
     * 查询组合商品审核列表
     * @param cond
     * @return
     */
    List<OpProductVO> findCombinedProdAuditList(OpProductCond cond);

    /**
     * 统计组合商品审核列表
     * @param cond
     * @return
     */
    Integer countCombinedProdAuditList(OpProductCond cond);


    /**
     * 审核组合商品
     * @param cond
     * @return
     */
    Boolean auditCombinedProd(OpProductCond cond);

    List<List<String>> convertSpvTempListByOpProductVO(Long prodId,List<String> groupNames,List<List<String>> result);

    List<List<String>> convertSpvDelTempListByOpProductVO(Long prodId,List<String> groupNames,List<List<String>> result);

    /**
     * 根据商品编码获取商品编号
     * @param code
     * @return
     */
    Long getIdByCode(String code);

    /**
     * 根据商品编号获取商品编码
     * @param bindingId
     * @return
     */
    String getCodeById(Long bindingId);
    
    /**
     * 查找指定的productCode是否存在非指定海淘类型的SKU
     * @param code
     * @return
     */
    Boolean getCrossBorderFlagListByCode(String code,Integer cross);

    /**
     * 查找指定的productCode是否存在非指定海淘类型的SKU
     * @param code
     * @return
     */
    Boolean getNewCrossBorderFlagListByCode(String code);
    
    /**
     * 查找指定的productCode是否存在预售类型的SKU
     * @param code
     * @param crossBorderFlag
     * @return
     */
    Boolean getIsPresaleByCode(String code);
    
    /**
     * 查找指定的productCode是否存在定制类型的SKU
     * @param code
     * @param crossBorderFlag
     * @return
     */
    Boolean getIsCustomizeByCode(String code);

    /**
     * 查找指定商品编码的商品下的sku集合
     *
     * @param productCode 商品编码
     *
     * @return
     */
    List<PcsSkuVO> getSkuListByProductCode(String productCode);

    /**
     * 查询所有的海淘或者非海淘  ProdID
     * @param tradeType
     * @return
     */
    List<Long> findProductIdsByTradeType(int tradeType);


    List<Long> findProdIdsByCategoryIds(List<Integer> categoryIds);

    List<Long> findProdIdsByBrandIds(List<Integer> categoryIds);

    /**
     * 获取指定商品编码关联的sku编码集合
     *
     * @param productCode
     *
     * @return
     */
    List<String> listSkuCodeByProductCode(String productCode);

    /**
     * 通过商品编码获取商品官网的可用库存数
     *
     * @param productCodes 待查询商品编码集合
     *
     * @return
     */
    Map<String, Integer> mapProductStockByCodes(List<String> productCodes);

    List<OpProductVO> findCombinedProdBySkuCode(String skuCode);

    /**
     * 获取指定商品编码对应的product信息
     *
     * @param productCodes 商品编码集合
     *
     * @return
     */
    Map<String, OpProductVO> mapProductByCodes(List<String> productCodes);

    Map<String, OpProductVO> mapProductByCodesNotTradeType(List<String> productCodes);

    /**
     * 获取所有商品的创建者唯一集合
     *
     * @return
     */
    List<ProdCreatorVO> listAllProdCreator();

    /**
     * 获取所有商品的最近提交审批人唯一集合
     *
     * @return
     */
    List<ProdCreatorVO> listAllProdApproveCreator();
}



