/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.cond;

import com.thebeastshop.pegasus.util.cond.BaseQueryCond;

import java.util.List;

/**
 * @author Roy.Chen
 * @version $Id: OpProductVO.java, v 0.1 2015-08-14 17:13
 */
public class OpProductCond extends BaseQueryCond {

    /**
     * 产品ID
     */
    private Long id;

    /**
     * 产品编码
     */
    private String code;

    private String skuCode; 
    
	private Integer buyId;

    private String brandName;

    /**
     * 是否组合商品
     */
    private Boolean combined;

    /**
     * 列表价
     */
    private Double listPrice;
    /**
     * 是否支持VIP折扣，1是0否
     */
    private Integer allowVipDiscount;
    /**
     * 是否支持代写卡片，0否1是
     */
    private Integer allowNoteCard;
    /**
     * 备货天数，默认0
     */
    private Integer prepareDays;
    /**
     * 可选择配送日期天数，0:尽快（不可选），n:n天内（默认n=7）
     */
    private Integer selectDeliveryDays;
    /**
     * 产品名
     */
    private String name;
    /**
     * 产品中文名
     */
    private String nameCn;

    /**
     * 是否关联属性
     */
    private Boolean withAttribute;

    /**
     * 是否关联SPV
     */
    private Boolean withSpv;

    /**
     * 是否关联SKU
     */
    private Boolean withSku;

    /**
     * 产品状态 ：0:草稿，1价格待审核2已驳回9审核通过
     */
    private Integer prodStatus;

    private List<Integer> prodStatusList;
    /**
     * 是否组合商品
     */
    private Boolean isCombined;

    /**
     * 价格变更状态：1变更中2通过3驳回
     */
    private Integer changeStatus;

    /**
     * 操作人
     */
    private String nickName;
    /**
     * 最近提交审批人
     */
    private String approveName;

    //多状态查询条件
    private Integer[] statusArr;
    
    
    private String sortField = "prod.id";
    
    private String sortType = "desc";
    
    private Long createUserId;
    
    private Integer approveUserId;

    public Integer getApproveUserId() {
        return approveUserId;
    }

    public void setApproveUserId(Integer approveUserId) {
        this.approveUserId = approveUserId;
    }

    public Long getCreateUserId() {
   		return createUserId;
   	}

   	public void setCreateUserId(Long createUserId) {
   		this.createUserId = createUserId;
   	}

    public List<Integer> getProdStatusList() {
        return prodStatusList;
    }

    public void setProdStatusList(List<Integer> prodStatusList) {
        this.prodStatusList = prodStatusList;
    }

    public String getSortField() {
		return sortField;
	}

	public void setSortField(String sortField) {
		this.sortField = sortField;
	}

	public String getSortType() {
		return sortType;
	}

	public void setSortType(String sortType) {
		this.sortType = sortType;
	}

	public Integer[] getStatusArr() {
		return statusArr;
	}

	public void setStatusArr(Integer[] statusArr) {
		this.statusArr = statusArr;
	}

	public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Double getListPrice() {
        return listPrice;
    }

    public void setListPrice(Double listPrice) {
        this.listPrice = listPrice;
    }

    public Integer getAllowVipDiscount() {
        return allowVipDiscount;
    }

    public void setAllowVipDiscount(Integer allowVipDiscount) {
        this.allowVipDiscount = allowVipDiscount;
    }

    public Integer getAllowNoteCard() {
        return allowNoteCard;
    }

    public void setAllowNoteCard(Integer allowNoteCard) {
        this.allowNoteCard = allowNoteCard;
    }

    public Integer getPrepareDays() {
        return prepareDays;
    }

    public void setPrepareDays(Integer prepareDays) {
        this.prepareDays = prepareDays;
    }

    public Integer getSelectDeliveryDays() {
        return selectDeliveryDays;
    }

    public void setSelectDeliveryDays(Integer selectDeliveryDays) {
        this.selectDeliveryDays = selectDeliveryDays;
    }

	public String getBrandName() {
		return brandName;
	}

	public void setBrandName(String brandName) {
		this.brandName = brandName;
	}

    public Integer getBuyId() {
		return buyId;
	}

	public void setBuyId(Integer buyId) {
		this.buyId = buyId;
	}

    public Boolean getWithAttribute() {
        return withAttribute;
    }

    public void setWithAttribute(Boolean withAttribute) {
        this.withAttribute = withAttribute;
    }

    public Boolean getWithSpv() {
        return withSpv;
    }

    public void setWithSpv(Boolean withSpv) {
        this.withSpv = withSpv;
    }

    public Boolean getWithSku() {
        return withSku;
    }

    public void setWithSku(Boolean withSku) {
        this.withSku = withSku;
    }

    public Boolean getCombined() {
        return isCombined;
    }

    public void setCombined(Boolean combined) {
        isCombined = combined;
    }

    public Integer getProdStatus() {
        return prodStatus;
    }

    public void setProdStatus(Integer prodStatus) {
        this.prodStatus = prodStatus;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getApproveName() {
        return approveName;
    }

    public void setApproveName(String approveName) {
        this.approveName = approveName;
    }
}
