package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 供应商状态
 * @author Gary
 *
 */
public enum OpProdSkuAttributeLineStatusEnum {
	
	REJECT((byte)0, "驳回"),
	REVIEW((byte)1, "待审核"),
	COMPLETED_REVIEW((byte)2, "审核完成");
	
	public final Byte status;
	public final String desc;

	public static final List<OpProdSkuAttributeLineStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private OpProdSkuAttributeLineStatusEnum(final Byte status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(Byte status) {
        for (OpProdSkuAttributeLineStatusEnum c : OpProdSkuAttributeLineStatusEnum .values()) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public Byte getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}
	
	
}
