package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.commdata.vo.CommFileRefVO;
import com.thebeastshop.common.enums.YesOrNoEnum;
import com.thebeastshop.pegasus.merchandise.enums.PcsSkuFlowerKindEnum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

public class McPcsFlowerSkuVO implements Serializable {

    private Long id;

    private String code;

    private String name;

    private String nameCn;

    private Long supplierId;

    private String supplierNameCn;

    private String placeOfOrigin;

    private String placeOfOriginDesc;

    private Integer skuFlowerKind;

    private String specification;//购买单位

    private Integer preBoxNum;//最小单位数量

    private BigDecimal skuMinUnitPrice;

    private BigDecimal costPrice;

    private String currencyCode;

    private String barcode;

    private BigDecimal salesPrice;

    private Integer skuShelfStatus;

    private String skuDescription;

    private Date createTime;

    private Long createUserId;

    private String createUserName;

    private Long operatorId;

    private String skuImgPath;//默认取第一个

    private List<String> skuImgPathList;

    private boolean updateSkuImg;

    private List<CommFileRefVO> skuImgFileRefList;


    public String getSkuFlowerKindDesc(){
        PcsSkuFlowerKindEnum kindEnum = PcsSkuFlowerKindEnum.valueOf(getSkuFlowerKind());
        return kindEnum == null?"":kindEnum.getName();
    }

    public String getSkuShelfStatusDesc(){
        return YesOrNoEnum.YES.getCode().equals(skuShelfStatus)?"上架":
                YesOrNoEnum.NO.getCode().equals(skuShelfStatus)?"下架":"";
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierNameCn() {
        return supplierNameCn;
    }

    public void setSupplierNameCn(String supplierNameCn) {
        this.supplierNameCn = supplierNameCn;
    }

    public String getPlaceOfOrigin() {
        return placeOfOrigin;
    }

    public void setPlaceOfOrigin(String placeOfOrigin) {
        this.placeOfOrigin = placeOfOrigin;
    }

    public String getPlaceOfOriginDesc() {
        return placeOfOriginDesc;
    }

    public void setPlaceOfOriginDesc(String placeOfOriginDesc) {
        this.placeOfOriginDesc = placeOfOriginDesc;
    }

    public Integer getSkuFlowerKind() {
        return skuFlowerKind;
    }

    public void setSkuFlowerKind(Integer skuFlowerKind) {
        this.skuFlowerKind = skuFlowerKind;
    }

    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public BigDecimal getSkuMinUnitPrice() {
        return skuMinUnitPrice;
    }

    public Integer getPreBoxNum() {
        return preBoxNum;
    }

    public void setPreBoxNum(Integer preBoxNum) {
        this.preBoxNum = preBoxNum;
    }

    public void setSkuMinUnitPrice(BigDecimal skuMinUnitPrice) {
        this.skuMinUnitPrice = skuMinUnitPrice;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getBarcode() {
        return barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public BigDecimal getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }

    public Integer getSkuShelfStatus() {
        return skuShelfStatus;
    }

    public void setSkuShelfStatus(Integer skuShelfStatus) {
        this.skuShelfStatus = skuShelfStatus;
    }

    public String getSkuDescription() {
        return skuDescription;
    }

    public void setSkuDescription(String skuDescription) {
        this.skuDescription = skuDescription;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public List<String> getSkuImgPathList() {
        return skuImgPathList;
    }

    public void setSkuImgPathList(List<String> skuImgPathList) {
        this.skuImgPathList = skuImgPathList;
    }

    public String getSkuImgPath() {
        return skuImgPath;
    }

    public void setSkuImgPath(String skuImgPath) {
        this.skuImgPath = skuImgPath;
    }

    public List<CommFileRefVO> getSkuImgFileRefList() {
        return skuImgFileRefList;
    }

    public void setSkuImgFileRefList(List<CommFileRefVO> skuImgFileRefList) {
        this.skuImgFileRefList = skuImgFileRefList;
    }

    public boolean isUpdateSkuImg() {
        return updateSkuImg;
    }

    public void setUpdateSkuImg(boolean updateSkuImg) {
        this.updateSkuImg = updateSkuImg;
    }
}
