/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.thebeastshop.common.utils.NumberUtil;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Roy.Chen
 * @version $Id: PubSkuVO.java, v 0.1 2015-08-06 10:26
 */
public class PsSkuVO implements Serializable {
    private String skuCode;

    private String skuNameCN;

    private Integer isJit;

    /**
     * 是否可定制
     */
    private Integer canCustomize;
    /**
     * 定制类型
     */
    private String customizeType;
    /**
     * 定制费
     */
    private BigDecimal customizationPrice;

    /**
     * 成本价
     */
    private BigDecimal costPrice;
//
    /**
     * 售价
     */
    private Double salesPrice;

    /**
     * 品类
     */
    private Long categoryId;
    private String categoryName;

//    /**
//     * 品牌
//     */
    private Long brandId;
    private String brandName;
    private String brandNameCN;

    /**
     * 是否可以备注
     */
    private Integer canRemark;

    /**
     * 跨境购标注 0普通１跨境购
     */
    private Integer crossBorderFlag;
//
    /**
     *  净重
     */
    private String weight;
    /**
     *  税号
     */
    private String taxNo;

    /**
     * 是否需要配送
     */
    private Integer whetherLogistics;

    /**
     * 是否需要配送
     */
    private Integer whetherVirtual;
    /**
     * -1：不展示, 0:无需安装，1：用户自行安装，2：需要安装
     */
    private Integer installService;
    /**
     * 是否是鲜花品类
     */
    private Integer flower;
//
    /**
     * 通关方式（0：未知，1：BC，2：个人）
     */
    private Short clearanceWay=0;
//


    private BigDecimal advancePrice;


    private Integer deliveryPeriod;

    private PcsCustomizeElementCacheVO pcsCustomizeElementCacheVO;

    private String skuImg;


    private String bu;

    private Integer sellOnLine;
//
    private Integer customPrintTemplate;//0:不支持 1:吊牌定制



	public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }


    public BigDecimal getCostPrice() {
        return costPrice;
    }
    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }
    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }



    public String getSkuNameCN() {
        return skuNameCN;
    }

    public void setSkuNameCN(String skuNameCN) {
        this.skuNameCN = skuNameCN;
    }


    public Integer getCanCustomize() {
        return canCustomize;
    }

    public void setCanCustomize(Integer canCustomize) {
        this.canCustomize = canCustomize;
    }

    public String getCustomizeType() {
        return customizeType;
    }

    public void setCustomizeType(String customizeType) {
        this.customizeType = customizeType;
    }

    public BigDecimal getCustomizationPrice() {
        return customizationPrice;
    }

    public void setCustomizationPrice(BigDecimal customizationPrice) {
        this.customizationPrice = customizationPrice;
    }


    public Double getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(Double salesPrice) {
        this.salesPrice = salesPrice;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }


    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }


//
    public String getBrandNameCN() {
        return brandNameCN;
    }

    public void setBrandNameCN(String brandNameCN) {
        this.brandNameCN = brandNameCN;
    }



    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }


    public Integer getCanRemark() {
        return canRemark;
    }

    public void setCanRemark(Integer canRemark) {
        this.canRemark = canRemark;
    }

    public Integer getIsJit() {
        return isJit;
    }

    public void setIsJit(Integer isJit) {
        this.isJit = isJit;
    }

    public String getWeight() {
        return weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public String getTaxNo() {
        return taxNo;
    }

    public void setTaxNo(String taxNo) {
        this.taxNo = taxNo;
    }

    public Short getClearanceWay() {
        return clearanceWay;
    }

    public void setClearanceWay(Short clearanceWay) {
        this.clearanceWay = clearanceWay;
    }


//
       public BigDecimal getAdvancePrice() {
        return advancePrice;
    }

    public void setAdvancePrice(BigDecimal advancePrice) {
        this.advancePrice = advancePrice;
    }

    public Integer getDeliveryPeriod() {
        return deliveryPeriod;
    }

    public void setDeliveryPeriod(Integer deliveryPeriod) {
        this.deliveryPeriod = deliveryPeriod;
    }



    public PcsCustomizeElementCacheVO getPcsCustomizeElementCacheVO() {
        return pcsCustomizeElementCacheVO;
    }

    public void setPcsCustomizeElementCacheVO(PcsCustomizeElementCacheVO pcsCustomizeElementCacheVO) {
        this.pcsCustomizeElementCacheVO = pcsCustomizeElementCacheVO;
    }

    public Integer getWhetherLogistics() {
        return whetherLogistics;
    }

    public void setWhetherLogistics(Integer whetherLogistics) {
        this.whetherLogistics = whetherLogistics;
    }

    public Integer getWhetherVirtual() {
        return whetherVirtual;
    }

    public void setWhetherVirtual(Integer whetherVirtual) {
        this.whetherVirtual = whetherVirtual;
    }

    public String getSkuImg() {
        return skuImg;
    }

    public void setSkuImg(String skuImg) {
        this.skuImg = skuImg;
    }

    public Integer getInstallService() {
        if(whetherLogistics != null && whetherLogistics == 1) {
            return installService;
        }else{
            return -1;
        }
    }

    public void setInstallService(Integer installService) {
        this.installService = installService;
    }


    public Integer getSellOnLine() {
        return sellOnLine;
    }

    public void setSellOnLine(Integer sellOnLine) {
        this.sellOnLine = sellOnLine;
    }

    public Integer getFlower() {
        return flower;
    }

    public void setFlower(Integer flower) {
        this.flower = flower;
    }

    public Integer getCustomPrintTemplate() {
        return customPrintTemplate;
    }

    public void setCustomPrintTemplate(Integer customPrintTemplate) {
        this.customPrintTemplate = customPrintTemplate;
    }

    public String getBu() {
        return bu;
    }

    public void setBu(String bu) {
        this.bu = bu;
    }
}
