package com.thebeastshop.pegasus.merchandise.enums;

/**
 * 免邮权益枚举
 * @Class Name InterestFreeEnum
 * @Author Xiang.Gao
 * @Create In 2017-3-21
 */
public enum InterestFreeEnum {
	
	/**
	 * 适用商品范围
	 */
	PRODUCT_SCOPE_FIXED("productScope", 0 ,"指定商品"),
	PRODUCT_SCOPE_ALL("productScope", 1 ,"全场商品"),
	
	/**
	 * 海淘/非海淘限制
	 */
	CROSS_BORDER_INLAND("crossBorder", 0 ,"非海淘"),
	CROSS_BORDER_OVERSEAS("crossBorder", 1 ,"海淘"),
	CROSS_BORDER_NOLIMIT("crossBorder", 2 ,"不限制"),
	
	/**
	 * 适用平台
	 */
	ACCESS_WAY_PC("accessWay", 1 ,"PC"),
	ACCESS_WAY_APP("accessWay", 2 ,"APP"),
	ACCESS_WAY_WAP("accessWay", 3 ,"WAP"),
	
	/**
	 * 使用时间方式
	 */
	USE_TIME_FIXED("useTime", 0 ,"固定时间"),
	USE_TIME_AFTER("useTime", 1 ,"领取后N天"),
	
	/**
	 * 绑定关系类型
	 */
	BINGDING_TYPE_PRODUCT("bingdingType", 0 ,"商品"),
	BINGDING_TYPE_CATEGORY("bingdingType", 1 ,"类目"),
	
	/**
	 * 是否为排除关系
	 */
	IS_EXCLUDE_FALSE("isExclude", 0 ,"非排除"),
	IS_EXCLUDE_TRUE("isExclude", 1 ,"排除"),
	
	/**
	 * 发放渠道
	 */
	PROVIDE_CHANNEL_MEMBER("provideChannel", 0 , "会员"),
	
	/**
	 * 状态
	 */
	FREE_STATUS_VALID("freeStatus", 0, "有效"),
	FREE_STATUS_USEUP("freeStatus", 1 ,"使用完"),
	FREE_STATUS_EXPIRED("freeStatus", 2 ,"已过期");
	
	private String type;
	private Integer code;
	private String desc;
	
	InterestFreeEnum(String type,Integer code,String desc) {
		this.type = type;
		this.code = code;
		this.desc = desc;
	}
	
	public static String getDesc(String type,Integer code) {
		for (InterestFreeEnum c : InterestFreeEnum.values()) {
			if(c.getType().equals(type) && c.getCode().equals(code)) {
                return c.getDesc();
			}
        }
		return null;
	}
	
	public static Integer getCode(String desc) {
        for (InterestFreeEnum c : InterestFreeEnum.values()) {
            if (c.getDesc().equals(desc)) {
                return c.getCode();
            }
        }
        return null;
	}
	
	public static boolean containsCode(Integer code) {
		for (InterestFreeEnum c : InterestFreeEnum.values()) {
            if (c.getCode().equals(code)) {
                return true;
            }
        }
        return false;
	}

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
}
