/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.enums.IposProdStatusEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author Roy.Chen
 * @version $Id: OpProductVO.java, v 0.1 2015-08-18 11:55
 */
public class PsProductVO implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -3925814543271833236L;

    private String id;

    /**
     * 产品编码
     */
    private String code;

    /**
    /**
     * 是否组合
     */
    private Boolean combined;

    /**
     * SPV列表
     */
    private List<PsSpvVO> spvList;

    /**
     * 属性列表
     */
//    private transient List<PsAttributeVO> attributeList;

    /**
     * 列表价
     */
    private BigDecimal listPrice;

    /**
     * 组合原价
     */
    private BigDecimal originalPrice;

    /**
     * 是否支持VIP折扣，1是0否
     */
    private Integer allowVipDiscount;

    /**
     * 是否支持生日折扣，1是0否
     */
    private Integer allowBdDiscount;

    /**
     * 是否支持优惠券，1是0否
     */
    private Integer allowCoupon;

    /**
     * 是否支持活动，1是0否
     */
    private Integer allowCampaign;

    /**
     * 是否支持代写卡片，0否1是
     */
    private Integer allowNoteCard;



    /**
     * 图片（列表）
     */
    private String picList;

    private String cropPicList;

    private String picMain;

    private String picListScene;


    /**
     * 图片（详情）
     */
//    private String picDetail;

    /**
     * 图片（缩略）
     */
//    private String picThumb;

    /**
     * 图片,手机端,多张以’，‘ 分割
     */
//    private String picDetailMul;
    private List<String> picDetailMuls;

    /**
     * 产品名
     */
    private String name;

    /**
     * 产品中文名
     */
    private String nameCn;

    /**
     * SKU分类描述
     */
    private transient String skuCategoryDesc;

    /**
     * prod category , last update sku's category
     */
    private Long categoryId;

    /**
     * prod category , last update sku's category
     */
    private String categoryCode;

    /**
     * 是否海淘
     */
    private Integer crossBorderFlag;

    /**
     * 是否来单
     */
    private Integer isJit;

    /**
     * 快递类型，1店送2联邦3顺丰
     */
    private Integer expressType;



    /**
     * 上架渠道编码
     */
    private List<String> onShelfChnCodes = new ArrayList<>();



    /**
     * prod all skus
     */
    private List<String> skuCodes = new ArrayList<>();

    /**
     * 渠道Prod可售sku
     */
    private List<PsChnProdSaleSkuVO> chnCanSaleSKu = new ArrayList<>();

    /**
     * 渠道Prod 可见 sku
     */
    private List<PsChnProdSaleSkuVO> chnCanSeeSKu = new ArrayList<>();



    /**
     * 是否预售
     */
    private Boolean hasPresale  = false;



    /**
     * 优惠活动
     */
    private List<PsCampaignVO> campaignList = new ArrayList<>();
    //transient
    private List<EsCampaignVO> esCampaignList = new ArrayList<>();


    /**
     * 产品渠道绑定信息
     * map key:{channelCode,createTime}
     */
//    private transient List<Map> channelProdInfo = new ArrayList<Map>();

//    private Integer seq;

//    private Integer sort1;

//    private Integer sort2;

//    private Date firstOnSaleTime;

    /**
     * 一句话描述
     */
    private String description;

    /**
     * 折扣价
     */
//    private BigDecimal discountPrice;

    /**
     * 生日折扣价
     */
//    private BigDecimal  bdDiscountPrice;

    /**
     * 列表页价格SpvId
     */
    private Long listPriceSpvId;

    /**
     * es总页数
     */
    private Long total;

    /**
     * 预告活动信息
     */
    private PsAdvanceCampaignVO psAdvanceCampaignVO;
    
    

    private String copywriter; //文案

    private Integer isDiscount;//是否特殊折扣

    private String video;//视频

    private String videoCover;//视频封面

    private String sceneVideo;
    private String sceneCover;

    private List<String> analysis;

    private List<PsBrandVO> brands = new ArrayList<>();

    private List<PsLabelVO> labels = new ArrayList<>();

    private List<PsSkuAttributeVO> skuAttributes = new ArrayList<>();



    private IposProdStatusEnum iposProdStatus; //ipos商品状态

    private Integer displayInCombinedArea; //组合搭配专区 1:展示 0:不展示



    private String onlyBu;

    private Integer isBigDetailImg;//是否是大图池里的商品 1:是 0:不是

    private Integer detailBigimgSeq;//详情页第几张作为大图， -1：最后一张

    private String detailBigimgUrl;//详情页大图URL

    private Integer isBeastCourse;//是否是野兽课堂 1:是 0:不是

    private Boolean isNewMember = false;//是否是新人专享

    private Integer isBirthday;//生日到店礼 1：是 0：不是

    private OpBeastCourseListVO beastCourseVOList; //野兽课堂

    private List<FrontPromotionVo> frontPromotionVoList;//购物返礼



    private String giftRecommendImg;
    private String giftRecommendReason;
    private Integer sellOnLine; //0:官网专享
    private Integer isWechatGift; //1:微信送礼
    //优惠券详情页是否展示 1：展示 0：不展示
    private Integer couponDetailShowFlag;
    //佣金率
    private BigDecimal commissionRate;


    private String listDisplayVideo;

    private FrontFinalPriceProdVO frontFinalPriceProdVO;



    /**
     * 使用基金比例
     * **/
    private BigDecimal useFundProportion;

    /**
     * 返基金比例
     * **/
    private BigDecimal returnFundProportion;

    private String fundActivityName;//基金活动名称

    private Integer isDeliveryDate;//时间是否支持 1:是 0:不是

    private Integer isDeliveryDistrict;//区域是否支持 1:是 0:不是

    /**
     * 是否支持VIP9折折扣，1是0否
     */
    private Integer isVipDiscountWhiteProd;

    private Integer customPrintTemplate;//0:不支持 1:吊牌定制

    private Integer hasDeliveryDate;//0:不支持可选配送日期 1:支持


    /**
     * 是否可定制
     */
    private Integer canCustomize;
    private Integer whetherLogistics; //1：大家具

    private Integer combination; //0:没有搭配组合商品 1:有

    private Integer isMatchProd; //0:不是搭配组合 1:是

    private List<MatchProductVO> matchProductVOList;  //搭配推荐商品

    private String matchProductTitle;//搭配推荐商品标题

    private String listPicCoordinate;//列表图坐标

    private List<Integer> limitProdIds; //商品限量ID

    public String getCopywriter() {
        return copywriter;
    }

    public void setCopywriter(String copywriter) {
        this.copywriter = copywriter;
    }

	public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }

    public List<PsSpvVO> getSpvList() {
        return spvList;
    }

    public void setSpvList(List<PsSpvVO> spvList) {
        this.spvList = spvList;
    }


    private List<PsCategoryVO> frontCategories;

    private List<PsChnStockVO> stocks;

    private List<String> smallIconList  = new ArrayList<String>();

    private List<String> largeIconList = new ArrayList<String>();


    private List<Integer> detailNumList = new ArrayList<Integer>();

    private List<PsTagVO> psTags = new ArrayList<PsTagVO>();




    /*
            是否有库存
             */
    private Integer isDeliveryStock;

    private Integer innerSort;


    public Integer getExpressType() {
        return expressType;
    }

    public void setExpressType(final Integer expressType) {
        this.expressType = expressType;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(final Long categoryId) {
        this.categoryId = categoryId;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public void setCategoryCode(final String categoryCode) {
        this.categoryCode = categoryCode;
    }

    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }

    public List<PsCategoryVO> getFrontCategories() {
        return frontCategories;
    }

    public void setFrontCategories(List<PsCategoryVO> frontCategories) {
        this.frontCategories = frontCategories;
    }

    public List<PsChnStockVO> getStocks() {
        return stocks;
    }

    public void setStocks(List<PsChnStockVO> stocks) {
        this.stocks = stocks;
    }

    public List<String> getSmallIconList() {
        return smallIconList;
    }

    public void setSmallIconList(List<String> smallIconList) {
        this.smallIconList = smallIconList;
    }

    public List<String> getLargeIconList() {
        return largeIconList;
    }

    public void setLargeIconList(List<String> largeIconList) {
        this.largeIconList = largeIconList;
    }



    public List<PsChnProdSaleSkuVO> getChnCanSaleSKu() {
        return chnCanSaleSKu;
    }

    public void setChnCanSaleSKu(final List<PsChnProdSaleSkuVO> chnCanSaleSKu) {
        this.chnCanSaleSKu = chnCanSaleSKu;
    }

    public List<String> getOnShelfChnCodes() {
        return onShelfChnCodes;
    }

    public void setOnShelfChnCodes(final List<String> onShelfChnCodes) {
        this.onShelfChnCodes = onShelfChnCodes;
    }



    public String getCode() {
        return code;
    }

    public void setCode(final String code) {
        this.code = code;
    }

    public BigDecimal getListPrice() {
        return listPrice;
    }

    public void setListPrice(final BigDecimal listPrice) {
        this.listPrice = listPrice;
    }

    public Integer getAllowVipDiscount() {
        return allowVipDiscount;
    }

    public void setAllowVipDiscount(final Integer allowVipDiscount) {
        this.allowVipDiscount = allowVipDiscount;
    }

    public Integer getAllowNoteCard() {
        return allowNoteCard;
    }

    public void setAllowNoteCard(final Integer allowNoteCard) {
        this.allowNoteCard = allowNoteCard;
    }


    public String getPicList() {
        return picList == null?"":picList;
    }

    public void setPicList(final String picList) {
        this.picList = picList;
    }


    public String getCropPicList() {
        return cropPicList == null ? "" : cropPicList;
    }

    public void setCropPicList(String cropPicList) {
        this.cropPicList = cropPicList;
    }

    public String getPicMain() {
        return picMain == null ? "" : picMain;
    }

    public void setPicMain(String picMain) {
        this.picMain = picMain;
    }

    public String getPicListScene() {
        return picListScene == null ? "" : picListScene;
    }

    public void setPicListScene(String picListScene) {
        this.picListScene = picListScene;
    }


    public String getName() {
        return name == null?"":name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn == null?"":nameCn;
    }

    public void setNameCn(final String nameCn) {
        this.nameCn = nameCn;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(final List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getSkuCategoryDesc() {
        return skuCategoryDesc;
    }

    public void setSkuCategoryDesc(final String skuCategoryDesc) {
        this.skuCategoryDesc = skuCategoryDesc;
    }

    public List<PsChnProdSaleSkuVO> getChnCanSeeSKu() {
        return chnCanSeeSKu;
    }

    public void setChnCanSeeSKu(final List<PsChnProdSaleSkuVO> chnCanSeeSKu) {
        this.chnCanSeeSKu = chnCanSeeSKu;
    }

    public List<PsCampaignVO> getCampaignList() {
        return campaignList;
    }

    public void setCampaignList(List<PsCampaignVO> campaignList) {
        this.campaignList = campaignList;
    }

    public List<EsCampaignVO> getEsCampaignList() {
        return esCampaignList;
    }

    public void setEsCampaignList(List<EsCampaignVO> esCampaignList) {
        this.esCampaignList = esCampaignList;
    }



    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public List<PsBrandVO> getBrands() {
        return brands;
    }

    public void setBrands(List<PsBrandVO> brands) {
        this.brands = brands;
    }

    public Long getListPriceSpvId() {
        return listPriceSpvId;
    }

    public void setListPriceSpvId(Long listPriceSpvId) {
        this.listPriceSpvId = listPriceSpvId;
    }

    public PsAdvanceCampaignVO getPsAdvanceCampaignVO() {
        return psAdvanceCampaignVO;
    }

    public void setPsAdvanceCampaignVO(PsAdvanceCampaignVO psAdvanceCampaignVO) {
        this.psAdvanceCampaignVO = psAdvanceCampaignVO;
    }

    public Integer getAllowBdDiscount() {
        return allowBdDiscount;
    }

    public void setAllowBdDiscount(Integer allowBdDiscount) {
        this.allowBdDiscount = allowBdDiscount;
    }

    public List<PsLabelVO> getLabels() {
        return labels;
    }

    public void setLabels(List<PsLabelVO> labels) {
        this.labels = labels;
    }

    public Integer getIsDiscount() {
        return isDiscount;
    }

    public void setIsDiscount(Integer isDiscount) {
        this.isDiscount = isDiscount;
    }

    public String getVideo() {
        return video;
    }

    public void setVideo(String video) {
        this.video = video;
    }

    public String getVideoCover() {
        return videoCover;
    }

    public void setVideoCover(String videoCover) {
        this.videoCover = videoCover;
    }

    public String getSceneVideo() {
        return sceneVideo;
    }

    public void setSceneVideo(String sceneVideo) {
        this.sceneVideo = sceneVideo;
    }

    public String getSceneCover() {
        return sceneCover;
    }

    public void setSceneCover(String sceneCover) {
        this.sceneCover = sceneCover;
    }

    public List<String> getAnalysis() {
        return analysis;
    }

    public void setAnalysis(List<String> analysis) {
        this.analysis = analysis;
    }

    public Boolean getHasPresale() {
        return hasPresale;
    }

    public void setHasPresale(Boolean hasPresale) {
        this.hasPresale = hasPresale;
    }

    /**
     * 获取渠道Prod下的可售sku列表
     * @param chnCode  渠道编码
     * @return
     */
    public List<String> getCanSaleSku(final String chnCode) {
        if (StringUtils.isBlank(chnCode)) {
            return Collections.emptyList();
        }

        for (final PsChnProdSaleSkuVO prodSaleSku : chnCanSaleSKu) {
            if (StringUtils.equals(prodSaleSku.getChnCode(), chnCode)) {
                final List<String> skus = new ArrayList<>();
                for (final String s : prodSaleSku.getCanSkus()) {
                    if (getSkuCodes().contains(s)) {
                        skus.add(s);
                    }
                }
//                prodSaleSku.getCanSkus().retainAll(getPromSkus());
//                return prodSaleSku.getCanSkus();
                return skus;
            }
        }

        return Collections.emptyList();
    }
    /**
     * 获取渠道Prod下的可见sku列表
     * @param chnCode  渠道编码
     * @return
     */
    public List<String> getCanSeeSku(final String chnCode) {
        if (StringUtils.isBlank(chnCode)) {
            return Collections.emptyList();
        }

        for (final PsChnProdSaleSkuVO prodSaleSku : chnCanSeeSKu) {
            if (StringUtils.equals(prodSaleSku.getChnCode(), chnCode)) {
                return prodSaleSku.getCanSkus();
            }
        }

        return Collections.emptyList();
    }

    public List<String> getPicDetailMuls() {
        return picDetailMuls;
    }

    public void setPicDetailMuls(List<String> picDetailMuls) {
        this.picDetailMuls = picDetailMuls;
    }



    public List<PsSkuAttributeVO> getSkuAttributes() {
        return skuAttributes;
    }

    public void setSkuAttributes(List<PsSkuAttributeVO> skuAttributes) {
        this.skuAttributes = skuAttributes;
    }

    public IposProdStatusEnum getIposProdStatus() {
        return iposProdStatus;
    }

    public void setIposProdStatus(IposProdStatusEnum iposProdStatus) {
        this.iposProdStatus = iposProdStatus;
    }

    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }

    public Integer getDisplayInCombinedArea() {
        return displayInCombinedArea;
    }

    public void setDisplayInCombinedArea(Integer displayInCombinedArea) {
        this.displayInCombinedArea = displayInCombinedArea;
    }

    public Integer getAllowCampaign() {
        return allowCampaign;
    }

    public void setAllowCampaign(Integer allowCampaign) {
        this.allowCampaign = allowCampaign;
    }

    public Integer getIsBigDetailImg() {
        return isBigDetailImg;
    }

    public void setIsBigDetailImg(Integer isBigDetailImg) {
        this.isBigDetailImg = isBigDetailImg;
    }

    public Integer getDetailBigimgSeq() {
        return detailBigimgSeq;
    }

    public void setDetailBigimgSeq(Integer detailBigimgSeq) {
        this.detailBigimgSeq = detailBigimgSeq;
    }

    public String getDetailBigimgUrl() {
        return detailBigimgUrl;
    }

    public void setDetailBigimgUrl(String detailBigimgUrl) {
        this.detailBigimgUrl = detailBigimgUrl;
    }

    public Integer getIsJit() {
        return isJit;
    }

    public void setIsJit(Integer isJit) {
        this.isJit = isJit;
    }

    public OpBeastCourseListVO getBeastCourseVOList() {
        return beastCourseVOList;
    }

    public void setBeastCourseVOList(OpBeastCourseListVO beastCourseVOList) {
        this.beastCourseVOList = beastCourseVOList;
    }

    public Integer getIsBeastCourse() {
        return isBeastCourse;
    }

    public void setIsBeastCourse(Integer isBeastCourse) {
        this.isBeastCourse = isBeastCourse;
    }

    public String getOnlyBu() {
        return onlyBu;
    }

    public void setOnlyBu(String onlyBu) {
        this.onlyBu = onlyBu;
    }

    public void setIsNewMember(Boolean isNewMember) {
        this.isNewMember = isNewMember;
    }

    public Integer getIsBirthday() {
        return isBirthday;
    }

    public void setIsBirthday(Integer isBirthday) {
        this.isBirthday = isBirthday;
    }

    public String getGiftRecommendImg() {
        return giftRecommendImg;
    }

    public void setGiftRecommendImg(String giftRecommendImg) {
        this.giftRecommendImg = giftRecommendImg;
    }

    public String getGiftRecommendReason() {
        return giftRecommendReason;
    }

    public void setGiftRecommendReason(String giftRecommendReason) {
        this.giftRecommendReason = giftRecommendReason;
    }

    public Integer getSellOnLine() {
        return sellOnLine;
    }

    public void setSellOnLine(Integer sellOnLine) {
        this.sellOnLine = sellOnLine;
    }

    public Integer getCouponDetailShowFlag() {
        return couponDetailShowFlag;
    }

    public void setCouponDetailShowFlag(Integer couponDetailShowFlag) {
        this.couponDetailShowFlag = couponDetailShowFlag;
    }

    public BigDecimal getCommissionRate() {
        return commissionRate;
    }

    public void setCommissionRate(BigDecimal commissionRate) {
        this.commissionRate = commissionRate;
    }

    public String getListDisplayVideo() {
        return listDisplayVideo;
    }

    public void setListDisplayVideo(String listDisplayVideo) {
        this.listDisplayVideo = listDisplayVideo;
    }

    public FrontFinalPriceProdVO getFrontFinalPriceProdVO() {
        return frontFinalPriceProdVO;
    }

    public void setFrontFinalPriceProdVO(FrontFinalPriceProdVO frontFinalPriceProdVO) {
        this.frontFinalPriceProdVO = frontFinalPriceProdVO;
    }

    public List<FrontPromotionVo> getFrontPromotionVoList() {
        return frontPromotionVoList;
    }

    public void setFrontPromotionVoList(List<FrontPromotionVo> frontPromotionVoList) {
        this.frontPromotionVoList = frontPromotionVoList;
    }

    public BigDecimal getUseFundProportion() {
        return useFundProportion;
    }

    public void setUseFundProportion(BigDecimal useFundProportion) {
        this.useFundProportion = useFundProportion;
    }

    public BigDecimal getReturnFundProportion() {
        return returnFundProportion;
    }

    public void setReturnFundProportion(BigDecimal returnFundProportion) {
        this.returnFundProportion = returnFundProportion;
    }

    public Integer getIsDeliveryDate() {
        return isDeliveryDate;
    }

    public void setIsDeliveryDate(Integer isDeliveryDate) {
        this.isDeliveryDate = isDeliveryDate;
    }

    public Integer getIsDeliveryDistrict() {
        return isDeliveryDistrict;
    }

    public void setIsDeliveryDistrict(Integer isDeliveryDistrict) {
        this.isDeliveryDistrict = isDeliveryDistrict;
    }

    public String getFundActivityName() {
        return fundActivityName;
    }

    public void setFundActivityName(String fundActivityName) {
        this.fundActivityName = fundActivityName;
    }

    public Integer getAllowCoupon() {
        return allowCoupon;
    }

    public void setAllowCoupon(Integer allowCoupon) {
        this.allowCoupon = allowCoupon;
    }

    public Integer getCustomPrintTemplate() {
        return customPrintTemplate;
    }

    public void setCustomPrintTemplate(Integer customPrintTemplate) {
        this.customPrintTemplate = customPrintTemplate;
    }

    public Integer getIsVipDiscountWhiteProd() {
        return isVipDiscountWhiteProd;
    }

    public void setIsVipDiscountWhiteProd(Integer isVipDiscountWhiteProd) {
        this.isVipDiscountWhiteProd = isVipDiscountWhiteProd;
    }

    public Integer getHasDeliveryDate() {
        return hasDeliveryDate;
    }

    public void setHasDeliveryDate(Integer hasDeliveryDate) {
        this.hasDeliveryDate = hasDeliveryDate;
    }


    public Integer getCanCustomize() {
        return canCustomize;
    }

    public void setCanCustomize(Integer canCustomize) {
        this.canCustomize = canCustomize;
    }

    public Integer getWhetherLogistics() {
        return whetherLogistics;
    }

    public void setWhetherLogistics(Integer whetherLogistics) {
        this.whetherLogistics = whetherLogistics;
    }

    public Boolean getIsNewMember() {
        return isNewMember;
    }


    public List<Integer> getDetailNumList() {
        return detailNumList;
    }

    public void setDetailNumList(List<Integer> detailNumList) {
        this.detailNumList = detailNumList;
    }

    public Integer getCombination() {
        return combination;
    }

    public void setCombination(Integer combination) {
        this.combination = combination;
    }

    public Integer getIsWechatGift() {
        return isWechatGift;
    }

    public void setIsWechatGift(Integer isWechatGift) {
        this.isWechatGift = isWechatGift;
    }

    public List<MatchProductVO> getMatchProductVOList() {
        return matchProductVOList;
    }

    public void setMatchProductVOList(List<MatchProductVO> matchProductVOList) {
        this.matchProductVOList = matchProductVOList;
    }

    public Integer getIsMatchProd() {
        return isMatchProd;
    }

    public void setIsMatchProd(Integer isMatchProd) {
        this.isMatchProd = isMatchProd;
    }

    public String getMatchProductTitle() {
        return matchProductTitle;
    }

    public void setMatchProductTitle(String matchProductTitle) {
        this.matchProductTitle = matchProductTitle;
    }

    public String getListPicCoordinate() {
        return listPicCoordinate;
    }

    public void setListPicCoordinate(String listPicCoordinate) {
        this.listPicCoordinate = listPicCoordinate;
    }

    public List<Integer> getLimitProdIds() {
        return limitProdIds;
    }

    public void setLimitProdIds(List<Integer> limitProdIds) {
        this.limitProdIds = limitProdIds;
    }

    public Integer getIsDeliveryStock() {
        return isDeliveryStock;
    }

    public void setIsDeliveryStock(Integer isDeliveryStock) {
        this.isDeliveryStock = isDeliveryStock;
    }

    public Integer getInnerSort() {
        return innerSort;
    }

    public void setInnerSort(Integer innerSort) {
        this.innerSort = innerSort;
    }

    @Override
    public String toString() {
        return "PsProductVO{" +
                "id='" + id + '\'' +
                ", code='" + code + '\'' +
                ", combined=" + combined +
                ", spvList=" + spvList +
//                ", attributeList=" + attributeList +
                ", listPrice=" + listPrice +
                ", allowVipDiscount=" + allowVipDiscount +
                ", allowNoteCard=" + allowNoteCard +
//                ", prepareDays=" + prepareDays +
//                ", selectDeliveryDays=" + selectDeliveryDays +
                ", picList='" + picList + '\'' +
//                ", picDetail='" + picDetail + '\'' +
//                ", picThumb='" + picThumb + '\'' +
//                ", picDetailMul='" + picDetailMul + '\'' +
                ", name='" + name + '\'' +
                ", nameCn='" + nameCn + '\'' +
                ", skuCategoryDesc='" + skuCategoryDesc + '\'' +
                ", categoryId=" + categoryId +
                ", categoryCode='" + categoryCode + '\'' +
                ", crossBorderFlag=" + crossBorderFlag +
                ", expressType=" + expressType +
//                ", selfDeliveries=" + selfDeliveries +
//                ", dynmContents=" + dynmContents +
                ", onShelfChnCodes=" + onShelfChnCodes +
                ", skuCodes=" + skuCodes +
                ", chnCanSaleSKu=" + chnCanSaleSKu +
                ", chnCanSeeSKu=" + chnCanSeeSKu +
                ", campaignList=" + campaignList +
//                ", saleStartDate=" + saleStartDate +
//                ", channelProdInfo=" + channelProdInfo +
                ", description='" + description + '\'' +
                ", listPriceSpvId=" + listPriceSpvId +
                ", total=" + total +
                ", advanceCampaignVO=" + psAdvanceCampaignVO +
                ", brands=" + brands +
                ", frontCategories=" + frontCategories +
                ", stocks=" + stocks +
                ", smallIconList=" + smallIconList +
                ", largeIconList=" + largeIconList +
//                ", psTags=" + psTags +
                '}';
    }
}






