package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 * sku状态枚举
 * @author Gary
 *
 */
public enum PcsSkuStatusEnum {
	
	REJECT(2, "驳回"),
	UNSUBIMITTED(0, "草稿"),
	/*CUSTOMS_REVIEW(5, "关务审批"),
	LEGAL_REVIEW(1, "品类经理审核"),
	FINANCE_REVIEW(3, "财务审核"),*/
	UNDER_REVIEW(1, "审批中"),
	COMPLETED_REVIEW(9, "审核完成");
	
	public final Integer status;
	public final String desc;

	public static final List<PcsSkuStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	PcsSkuStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}


	public final static List<Integer> statusListInTheReview() {
	  List<Integer> list = new ArrayList<>();
	  list.add(UNDER_REVIEW.getStatus());
      //list.add(CUSTOMS_REVIEW.status);
	  //list.add(FINANCE_REVIEW.status);
	  return list;
	}

	public final static List<Map<String, Object>> listMapEnum() {
		List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
		for (PcsSkuStatusEnum skuStatusEnum : PcsSkuStatusEnum.values()) {
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("value", skuStatusEnum.status);
			map.put("name", skuStatusEnum.desc);
			listMap.add(map);
		}
		return listMap;
	}

	 // 普通方法
    public static String getDesc(int status) {
			for (PcsSkuStatusEnum c : ALL) {
					if (c.getStatus() == status) {
							return c.desc;
					}
			}
			return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
