package com.thebeastshop.pegasus.merchandise.enums;

import com.thebeastshop.common.enums.CodeEnum;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum SupplierKindEnum implements CodeEnum<Integer> {

    NORMAL(1, "普通"),
    FLOWER(2, "鲜花");

    private Integer code;
    private String name;

    SupplierKindEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    private static final List<SupplierKindEnum> ALL = Collections.unmodifiableList(Arrays.asList(SupplierKindEnum.values()));

    public static String getNameByCode(Integer code){
        return ALL.stream()
                .filter(item->item.getCode().equals(code))
                .map(SupplierKindEnum::getName)
                .findAny().orElse("");
    }

    public static SupplierKindEnum getEnumByCode(Integer code){
        return ALL.stream()
                .filter(item->item.getCode().equals(code))
                .findAny().orElse(null);
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }
}
