package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author gongjun[dt_flys@hotmail.com]
 * @since 2016-11-14 23:46
 */
public enum DiscountTypeEnum {

    /**
     * 价格折扣
     */
    OFF(1, "价格折扣"),
    /**
     * 满减
     */
    CHEAPEN(2, "满减"),
    /**
     * 满折
     */
    DIC(5, "满折"),
    /**
     * 满赠
     */
    GIFT(3, "满赠"),
    /**
     * 加价购
     */
    CHEAPEN_OTHER(4, "换购"),
    /**
     * 抢购
     */
    PANIC_BUY(6, "抢购"),
    /**
	 * N元任选
	 */
	OPTION(7, "N元任选"),
    /**
     * 拼团
     */
    GROUP_BUY(8, "拼团");

    public final Integer id;
    public final String name;

    public static final List<DiscountTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    public static DiscountTypeEnum valueOf(Integer id) {
        for (DiscountTypeEnum discountTypeEnum : ALL) {
            if (discountTypeEnum.getId().equals(id)) {
                return discountTypeEnum;
            }
        }
        return null;
    }

    DiscountTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    public Integer getId() {
        return id;
    }

    public String getName() {
        return name;
    }


}
