package com.thebeastshop.pegasus.merchandise.enums;

/**
 * @author hafiz.zhang
 * @description: 动态内容类型
 * @date Created in 2018/5/31 17:31.
 */
public enum DynmTypeEnum {
    IMAGE(1, "图片"),
    TEXT(2, "文字"),
    TABLE(3, "表格")
    ;
    private Integer type;
    private String desc;

    DynmTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static DynmTypeEnum getEnumByType(Integer type) {
        for (DynmTypeEnum dynmTypeEnum : DynmTypeEnum.values()) {
            if (dynmTypeEnum.getType().equals(type)) {
                return dynmTypeEnum;
            }
        }
        return null;
    }
}
