package com.thebeastshop.pegasus.merchandise.vo;

import com.google.common.base.CaseFormat;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractDomain implements Serializable {

    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());

    public AbstractDomain() {
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this, new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj, new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public Map<String, Object> toMap() {
        Map<String, Object> returnMap = new LinkedHashMap();

        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
            PropertyDescriptor[] var6 = propertyDescriptors;
            int var5 = propertyDescriptors.length;

            for(int var4 = 0; var4 < var5; ++var4) {
                PropertyDescriptor propertyDescriptor = var6[var4];
                String propertyName = propertyDescriptor.getName();
                if (!"class".equals(propertyName)) {
                    Method readMethod = propertyDescriptor.getReadMethod();
                    Object result = readMethod.invoke(this);
                    returnMap.put(propertyName, result);
                }
            }
        } catch (Exception var10) {
            this.log.error("toMap ERROR.", var10);
            //var10.printStackTrace();
        }

        return returnMap;
    }

    public Map<String, Object> toMapKeyToUnderscore() {
        Map<String, Object> beanMap = this.toMap();
        Map<String, Object> result = new HashMap();
        Iterator var4 = beanMap.keySet().iterator();

        while(var4.hasNext()) {
            String key = (String)var4.next();
            Object value = beanMap.get(key);
            String lower_underscore_key = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, key);
            result.put(lower_underscore_key, value);
        }

        return result;
    }
}
