package com.thebeastshop.pegasus.merchandise.service;

import com.thebeastshop.common.Pagination;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuClassificationCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuDiscountActivityApplyCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuClassificationVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuDiscountActivityApplyVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuDiscountActivityVO;

import java.util.List;
import java.util.Map;

/**
 * @BelongsProject: workspace
 * @BelongsPackage: com.thebeastshop.pegasus.merchandise.service
 * @Author: Gary
 * @CreateTime: 2025-03-06  14:48
 * @Description: 商品价格折扣提报
 * @Version: 1.0
 */
public interface McPcsSkuPriceDiscountApplyService {

    Pagination<PcsSkuClassificationVO> querySkuClassificationByCond(PcsSkuClassificationCond cond);

    PcsSkuClassificationVO getSkuClassification(Integer classificationId);

    PcsSkuClassificationVO saveSkuClassification(PcsSkuClassificationVO vo);

    int deleteSkuClassification(Integer id);

    int savePcsSkuDiscountActivity(List<PcsSkuDiscountActivityVO> discountActivityList);

    List<PcsSkuDiscountActivityVO> listPcsSkuDiscountActivity();

    Pagination<PcsSkuDiscountActivityApplyVO> querySkuDiscountActivityApplyByCond(PcsSkuDiscountActivityApplyCond cond);

    PcsSkuDiscountActivityApplyVO getSkuDiscountActivityApply(Integer applyId);

    PcsSkuDiscountActivityApplyVO saveSkuDiscountActivityApply(PcsSkuDiscountActivityApplyVO vo);

    void auditSkuDiscountActivityApply(Integer applyId);

    Map<String, Boolean> mapSkuAudited(List<String> skuCodeList);
}
