package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.pegasus.merchandise.enums.IposProdStatusEnum;


import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class PsProductBaseVO implements Serializable {

    private String id;

    /**
     * 产品编码
     */
    private String code;

    /**
    /**
     * 是否组合
     */
    private Boolean combined;

    /**
     * SPV列表
     */
    private List<PsSpvBaseVO> spvList;



    /**
     * 列表价
     */
    private BigDecimal listPrice;

    /**
     * 组合原价
     */
    private BigDecimal originalPrice;

    /**
     * 是否支持VIP折扣，1是0否
     */
    private Integer allowVipDiscount;

    /**
     * 是否支持生日折扣，1是0否
     */
    private Integer allowBdDiscount;

    /**
     * 是否支持优惠券，1是0否
     */
    private Integer allowCoupon;

    /**
     * 是否支持活动，1是0否
     */
    private Integer allowCampaign;

    /**
     * 是否支持代写卡片，0否1是
     */
    private Integer allowNoteCard;

    /**
     * 产品名
     */
    private String name;

    /**
     * 产品中文名
     */
    private String nameCn;

    /**
     * prod category , last update sku's category
     */
    private Long categoryId;


    /**
     * 是否海淘
     */
    private Integer crossBorderFlag;

    /**
     * 是否来单
     */
    private Integer isJit;

    /**
     * 快递类型，1店送2联邦3顺丰
     */
    private Integer expressType;

    /**
     * prod all skus
     */
    private List<String> skuCodes = new ArrayList<>();

    /**
     * 是否预售
     */
    private Boolean hasPresale  = false;

    /**
     * 优惠活动
     */
    private List<PsCampaignVO> campaignList = new ArrayList<>();

    /**
     * 一句话描述
     */
    private String description;

    /**
     * 列表页价格SpvId
     */
    private Long listPriceSpvId;

    /**
     * 预告活动信息
     */
    private PsAdvanceCampaignVO psAdvanceCampaignVO;


    private Integer isDiscount;//是否特殊折扣

    private Integer isBeastCourse;//是否是野兽课堂 1:是 0:不是

    private Boolean isNewMember = false;//是否是新人专享

    private Integer isBirthday;//生日到店礼 1：是 0：不是


    /**
     * 使用基金比例
     * **/
    private BigDecimal useFundProportion;
    /**
     * 返基金比例
     * **/
    private BigDecimal returnFundProportion;

    private String fundActivityName;//基金活动名称

    /**
     * 是否支持VIP9折折扣，1是0否
     */
    private Integer isVipDiscountWhiteProd;

    private Integer hasDeliveryDate;//0:不支持可选配送日期 1:支持


    /**
     * 是否可定制
     */
    private Integer canCustomize;
    private Integer whetherLogistics; //1：大家具

    private Integer combination; //0:没有搭配组合商品 1:有

    private Integer isMatchProd; //0:不是搭配组合 1:是

    private List<Integer> limitProdIds; //商品限量ID



	public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }

    public List<PsSpvBaseVO> getSpvList() {
        return spvList;
    }

    public void setSpvList(List<PsSpvBaseVO> spvList) {
        this.spvList = spvList;
    }





    public Integer getExpressType() {
        return expressType;
    }

    public void setExpressType(final Integer expressType) {
        this.expressType = expressType;
    }

    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(final Long categoryId) {
        this.categoryId = categoryId;
    }


    public Integer getCrossBorderFlag() {
        return crossBorderFlag;
    }

    public void setCrossBorderFlag(Integer crossBorderFlag) {
        this.crossBorderFlag = crossBorderFlag;
    }





    public String getCode() {
        return code;
    }

    public void setCode(final String code) {
        this.code = code;
    }

    public BigDecimal getListPrice() {
        return listPrice;
    }

    public void setListPrice(final BigDecimal listPrice) {
        this.listPrice = listPrice;
    }

    public Integer getAllowVipDiscount() {
        return allowVipDiscount;
    }

    public void setAllowVipDiscount(final Integer allowVipDiscount) {
        this.allowVipDiscount = allowVipDiscount;
    }

    public Integer getAllowNoteCard() {
        return allowNoteCard;
    }

    public void setAllowNoteCard(final Integer allowNoteCard) {
        this.allowNoteCard = allowNoteCard;
    }




    public String getName() {
        return name == null?"":name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn == null?"":nameCn;
    }

    public void setNameCn(final String nameCn) {
        this.nameCn = nameCn;
    }

    public List<String> getSkuCodes() {
        return skuCodes;
    }

    public void setSkuCodes(final List<String> skuCodes) {
        this.skuCodes = skuCodes;
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }


    public List<PsCampaignVO> getCampaignList() {
        return campaignList;
    }

    public void setCampaignList(List<PsCampaignVO> campaignList) {
        this.campaignList = campaignList;
    }




    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }



    public Long getListPriceSpvId() {
        return listPriceSpvId;
    }

    public void setListPriceSpvId(Long listPriceSpvId) {
        this.listPriceSpvId = listPriceSpvId;
    }

    public PsAdvanceCampaignVO getPsAdvanceCampaignVO() {
        return psAdvanceCampaignVO;
    }

    public void setPsAdvanceCampaignVO(PsAdvanceCampaignVO psAdvanceCampaignVO) {
        this.psAdvanceCampaignVO = psAdvanceCampaignVO;
    }

    public Integer getAllowBdDiscount() {
        return allowBdDiscount;
    }

    public void setAllowBdDiscount(Integer allowBdDiscount) {
        this.allowBdDiscount = allowBdDiscount;
    }



    public Integer getIsDiscount() {
        return isDiscount;
    }

    public void setIsDiscount(Integer isDiscount) {
        this.isDiscount = isDiscount;
    }


    public Boolean getHasPresale() {
        return hasPresale;
    }

    public void setHasPresale(Boolean hasPresale) {
        this.hasPresale = hasPresale;
    }



    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }



    public Integer getAllowCampaign() {
        return allowCampaign;
    }

    public void setAllowCampaign(Integer allowCampaign) {
        this.allowCampaign = allowCampaign;
    }


    public Integer getIsJit() {
        return isJit;
    }

    public void setIsJit(Integer isJit) {
        this.isJit = isJit;
    }



    public Integer getIsBeastCourse() {
        return isBeastCourse;
    }

    public void setIsBeastCourse(Integer isBeastCourse) {
        this.isBeastCourse = isBeastCourse;
    }



    public void setIsNewMember(Boolean isNewMember) {
        this.isNewMember = isNewMember;
    }

    public Integer getIsBirthday() {
        return isBirthday;
    }

    public void setIsBirthday(Integer isBirthday) {
        this.isBirthday = isBirthday;
    }



    public BigDecimal getUseFundProportion() {
        return useFundProportion;
    }

    public void setUseFundProportion(BigDecimal useFundProportion) {
        this.useFundProportion = useFundProportion;
    }

    public BigDecimal getReturnFundProportion() {
        return returnFundProportion;
    }

    public void setReturnFundProportion(BigDecimal returnFundProportion) {
        this.returnFundProportion = returnFundProportion;
    }


    public String getFundActivityName() {
        return fundActivityName;
    }

    public void setFundActivityName(String fundActivityName) {
        this.fundActivityName = fundActivityName;
    }

    public Integer getAllowCoupon() {
        return allowCoupon;
    }

    public void setAllowCoupon(Integer allowCoupon) {
        this.allowCoupon = allowCoupon;
    }


    public Integer getIsVipDiscountWhiteProd() {
        return isVipDiscountWhiteProd;
    }

    public void setIsVipDiscountWhiteProd(Integer isVipDiscountWhiteProd) {
        this.isVipDiscountWhiteProd = isVipDiscountWhiteProd;
    }

    public Integer getHasDeliveryDate() {
        return hasDeliveryDate;
    }

    public void setHasDeliveryDate(Integer hasDeliveryDate) {
        this.hasDeliveryDate = hasDeliveryDate;
    }


    public Integer getCanCustomize() {
        return canCustomize;
    }

    public void setCanCustomize(Integer canCustomize) {
        this.canCustomize = canCustomize;
    }

    public Integer getWhetherLogistics() {
        return whetherLogistics;
    }

    public void setWhetherLogistics(Integer whetherLogistics) {
        this.whetherLogistics = whetherLogistics;
    }

    public Boolean getIsNewMember() {
        return isNewMember;
    }




    public Integer getCombination() {
        return combination;
    }

    public void setCombination(Integer combination) {
        this.combination = combination;
    }



    public Integer getIsMatchProd() {
        return isMatchProd;
    }

    public void setIsMatchProd(Integer isMatchProd) {
        this.isMatchProd = isMatchProd;
    }


    public List<Integer> getLimitProdIds() {
        return limitProdIds;
    }

    public void setLimitProdIds(List<Integer> limitProdIds) {
        this.limitProdIds = limitProdIds;
    }


}






