package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCond;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCmSplVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCustomMadeVO;

import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: PcsSkuCustomMade.java, v 0.1 2015-08-06 13:05
 */
public interface McPcsSkuCustomMadeService {


    /**
     * 创建实体
     *
     * @param record
     * @return
     */
    PcsSkuCustomMadeVO create(PcsSkuCustomMadeVO record);

    /**
     * 更新实体
     *
     * @param record
     * @return
     */
    boolean update(PcsSkuCustomMadeVO record);

    /**
     * 根据主键查找实体
     *
     * @param id
     * @return
     */
    PcsSkuCustomMadeVO findSkuCustomMadeById(long id);

    /**
     * 根据主键查找实体
     *
     * @param id
     * @return
     */
    PcsSkuCustomMadeVO findById(long id);

    /**
     * 根据CODE查找实体
     * @param code
     * @return
     */
    PcsSkuCustomMadeVO findSkuCustomMadeByCode(String code);

    /**
     * 根据条件查找实体
     *
     * @param cond
     * @return
     */
    List<PcsSkuCustomMadeVO> findSkuCustomMadeByCond(PcsSkuCond cond);

    /**
     * 创建SKU定制信息,包括SKU主题信息和供应商行信息
     *
     * @return
     */
    Boolean createCustomMadeAndLine(PcsSkuCustomMadeVO pcsSkuCustomMadeVO);

    /**
     * 更新SKU定制信息,包括SKU主题信息和供应商行信息
     *
     * @return
     */
    Boolean updateCustomMadeAndLine(PcsSkuCustomMadeVO pcsSkuCustomMadeVO);

    /**
     * 根据定制单ID和关联的供应商ID删除供应商信息
     *
     * @param skuCustomMadeId
     * @param skuCmSplId
     * @return
     */
    Boolean deletePcsCmSpl(long skuCustomMadeId, long skuCmSplId);

    /**
     * sku定制审批转换供应商
     *
     * @param skuCustomMadeId
     * @param skuCmSplId
     * @return
     */
    Boolean convertCustomMadeAndLine(long skuCustomMadeId, long skuCmSplId);

    /**
     * sku定制审批-驳回
     *
     * @param skuCustomMadeId
     * @return
     */
    Boolean rejectCustomMade(long skuCustomMadeId);

}
