package com.thebeastshop.pegasus.merchandise.exception;


import com.thebeastshop.common.exception.BaseErrorCode;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-04-25 16:12
 */
public enum DynmDetailsExceptionCode implements BaseErrorCode {
    /**
     * 通用
     */

    // 参数为空
    NULL_PARAM("0001", "参数为空"),

    // 参数内容为空
    EMPTY_PARAM("0002", "参数内容为空"),

    // 参数未验证通过
    ILLEGAL_PARAM("0003", "参数错误"),

    // 状态与预期不符
    ERROR_CODE_PREFIX("0004", "状态与预期不符"),

    // 版本与预期不符
    VERSION_NOT_EXPECTED("0005", "版本与预期不符"),

    // 结果与预期不符
    RESULT_NOT_EXPECTED("0006", "结果与预期不符"),

    CONVERTER_ERROR("0007", "解析错误"),

    // 验证失败
    VALIDATION_FAIL("0008", "验证失败"),

    // 数据未找到
    DATA_NOT_FOUND("0009", "数据未找到"),

    // 数据更新失败
    DBA_UPDATE_ERROR("DB_UPDATE_001", "数据更新失败"),


    // 数据更新失败
    DBA_INSERT_ERROR("DB_INSERT_001", "数据新增失败"),
    ;

    DynmDetailsExceptionCode(String errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    private final String prefix = "CP";

    private String errorCode;

    private String message;

    @Override
    public String getPrefix() {
        return prefix;
    }

    @Override
    public String getErrorCode() {
        return prefix + errorCode;
    }

    @Override
    public String getMessage() {
        return message;
    }


    public String toString() {
        return  "prefix=[" + this.getPrefix() + "],code=[" + this.getErrorCode() + "],msg=[" + this.getMessage() + "]";
    }
}
