/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.ObjectChangeLog;
import com.thebeastshop.pegasus.merchandise.annotation.ObjectPropertyValCompare;
import com.thebeastshop.pegasus.merchandise.enums.PcsSupplierOrderStatusEnum;
import com.thebeastshop.pegasus.merchandise.enums.PcsTaxpayerTypeEnum;
import com.thebeastshop.pegasus.merchandise.enums.SupplierKindEnum;
import com.thebeastshop.pegasus.merchandise.enums.SupplierTypeEnum;
import com.thebeastshop.pegasus.merchandise.util.DateUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author Eric.Lou
 * @version $Id: PcsSupplierVO.java, v 0.1 2015-07-28 17:42
 */
public class PcsSupplierVO implements Serializable {

    /**
	 * 
	 */
	private static final long serialVersionUID = 4885885279455337494L;

	//审核完成
	public final static int STATUS_FINISH = 3;


	// constructor
    public PcsSupplierVO() {

    }

    // original
    private Long id;

    @ObjectPropertyValCompare
	@ObjectChangeLog(name = "供应商名")
    private String name;
    
    @ObjectPropertyValCompare
	@ObjectChangeLog(name = "供应商中文名")
    private String nameCn;

    private Date createTime;

	@ObjectPropertyValCompare
    private Integer supplierStatus;

    private String supplierStatusRemark;

    private static final Map<Boolean, String> SWITCH_STATUS = new HashMap<Boolean, String>(){{
    	put(true, "启用");
    	put(false, "禁用");
	}};

    private String contacterName;

    private Integer contacterGender;

    private String contacterPhone;

    private String contacterMobile;

    private String contacterEmail;

    private Long districtId;

	@ObjectChangeLog(name = "具体地址")
    private String address;

    private String fullAddress;
	private Integer forbidPayment;
	@ObjectChangeLog(name = "邮编")
    private String zipCode;
    
    @ObjectPropertyValCompare
    private String purchaseCurrencyCode;

    private String purchaseCurrencyDesc;

    private String paymentTerm;

    private Integer fileId;

	@ObjectChangeLog(name = "备注")
    private String remark;

    // self
    private String fileName;
    
    private Integer isNational;//1：国内，0：海外

	@ObjectChangeLog(name = "区域")
    private String nationalDesc;

    @ObjectPropertyValCompare
    private Integer businessLicense;//营业执照
    
    @ObjectPropertyValCompare
    private Integer orgCodeCertificate;//组织机构代码证
    
    @ObjectPropertyValCompare
    private Integer taxRegistrationCertificate;//税务登记证
    
    @ObjectPropertyValCompare
    private Integer taxpayerCertificate;//纳税人证明
    
    @ObjectPropertyValCompare
	private Integer registrationCertificate;//注册证明书

	//供应商账号信息
	@ObjectPropertyValCompare
	private PcsSupplierAccountInfoVO accountInfo;

	//供应商品牌信息
	@ObjectChangeLog(name = "关联品牌")
	private String brandArr;

	private List<PcsSupplierBrandRelationVO> brands;

	//供应商文件
	private List<PcsSupplierFileVO> files;
    
	private Integer supplierOrderStatus;
	private String supplierOrderStatusName;

	private Date finishedTime;
	
	//1:提交审核
	private Integer optType;
	
	@ObjectPropertyValCompare
	@ObjectChangeLog(name = "发票税率")
	private BigDecimal invoiceTaxRate; //发票税率
	
	@ObjectPropertyValCompare
	private Integer taxpayerType;//纳税人类型

	//纳税人类型
	@ObjectChangeLog(name = "纳税人类型")
	private String taxpayerTypeName;

	private Long creator;
	    
    private Long lastModifier;
	    
    private String creatorCN;
	    
    private String lastModifierCN;

	private Long submitAuditUserId;
    private boolean saveDraft;
    
    //结算方式类型
    private Integer paymentTermType;

    //结算方式类型
	@ObjectChangeLog(name = "结算方式")
    private Integer paymentTermTypeName;

    //商业品类
  	private List<String> categoryList;
  	
  	//采购品类
  	private List<String> purchaseCategoryList;
    
  	//供应商类型
    private Integer supplierType;

    private Date lastAuditTime;
    
    private Date lastSubmitTime;
    
    private String lastApproverName;
    
    private String lastAuditRemark;
    
    private Long lastApprover;
    
    private String factoryCertifiedDocuments;
    
    private List<Long> manufacturers;
    
    private List<PcsSupplierManufacturerVO> manufacturerList;
    private List<PcsSupplierPaymentVO> pcsSupplierPaymentVOList;
    private String allManufacturers;

	private Integer supplierKind;//供应商种类

	private List<Long> supplyCityList;//供应城市

	// 供应商返点配置信息
	private List<PcsSupplierRebatesConfigVO> rebatesConfigVOS;

    //工厂证明文件OSS  ID list
    private List<Long> factoryFileIds;
    
    private String factoryCertifiedDocumentsName;

	private String businessScope;
    
    //工厂证明文件名List
    private List<String> factoryFileNames;
    
    private Boolean havePermission = false;	// 有权限的且状态为可用的所有SKU使用的供应商(是否有权限编辑和查看完成信息)

	// 当前用户可以审批
	private Boolean currUserCanAudit = false;

	private boolean needAuditSupplierStatus;
	private boolean paymentChange = false;
    // 供应商联系人列表
    private List<PcsSupplierContactVO> supplierContactVOs;

    private List<PcsSupplierAuditRecordVO> supplierAuditRecordVOS;

    private boolean optRebatesFlag;

	private BigDecimal ratio;

	private String countryName;

	private Integer forbidPo;

    public String getHasBeenWaiting() {
    	String hasBeenWaiting = "";
    	if(EmptyUtil.isEmpty(lastSubmitTime)) {
    		hasBeenWaiting =  "0天0小时";
    	} else {
    		hasBeenWaiting = DateUtils.workDays(DateUtil.format(lastSubmitTime, "yyyy-MM-dd HH:mm:ss"),
    				DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
    	}
		return hasBeenWaiting;
	}
    
    
    public String getNationalDesc() {
    	if(isNational == null) {
    		return "";
    	} else if(isNational == 1) {
    		return "国内";
    	} else {
    		return "国外";
    	}
    }
    
    public String getGenderDesc() {
    	if(contacterGender == null) {
    		return "未知";
    	}else if(contacterGender == 0) {
    		return "保密";
    	} else if(contacterGender == 1) {
    		return "男";
    	} else {
    		return "女";
    	}
    }

	public Long getSubmitAuditUserId() {
		return submitAuditUserId;
	}

	public void setSubmitAuditUserId(Long submitAuditUserId) {
		this.submitAuditUserId = submitAuditUserId;
	}

	public void setAllManufacturers(String allManufacturers) {
		this.allManufacturers = allManufacturers;
	}


	public String getAllManufacturers() {
    	StringBuffer manufacturers = new StringBuffer();
    	if(EmptyUtil.isNotEmpty(this.manufacturerList)) {
    		for(PcsSupplierManufacturerVO pcsSupplierManufacturerVO : manufacturerList) {
    			if(manufacturers.length() != 0) {
    				manufacturers.append(",");
    			}
    			manufacturers.append("[");
    			manufacturers.append(pcsSupplierManufacturerVO.getManufacturerId());
    			manufacturers.append("]");
    			manufacturers.append(pcsSupplierManufacturerVO.getManufacturer());
    			manufacturers.append("[");
    			manufacturers.append(pcsSupplierManufacturerVO.getManufacturerStatusDesc());
    			manufacturers.append("]");
    		}
    	}
    	return manufacturers.toString();
    }
	
	
	
    
    public List<Long> getFactoryFileIds() {
    	factoryFileIds = new ArrayList<Long>();
    	if(EmptyUtil.isNotEmpty(factoryCertifiedDocuments)) {
    		String[]  factoryCertifiedDocumentsArr = factoryCertifiedDocuments.split(",");
    		for(String factoryCertifiedDocument: factoryCertifiedDocumentsArr) {
    			factoryFileIds.add(Long.valueOf(factoryCertifiedDocument));
    		}
    	}
		return factoryFileIds;
	}


	public void setFactoryFileIds(List<Long> factoryFileIds) {
		this.factoryFileIds = factoryFileIds;
	}
	
	


	public String getFactoryCertifiedDocumentsName() {
		return factoryCertifiedDocumentsName;
	}


	public void setFactoryCertifiedDocumentsName(String factoryCertifiedDocumentsName) {
		this.factoryCertifiedDocumentsName = factoryCertifiedDocumentsName;
	}

	public String getBusinessScope() {
		return businessScope;
	}

	public void setBusinessScope(String businessScope) {
		this.businessScope = businessScope;
	}

	public List<String> getFactoryFileNames() {
		factoryFileNames = new ArrayList<String>();
    	if(EmptyUtil.isNotEmpty(factoryCertifiedDocumentsName)) {
    		String[]  factoryCertifiedDocumentsArr = factoryCertifiedDocumentsName.split(",");
    		for(String factoryCertifiedDocument: factoryCertifiedDocumentsArr) {
    			factoryFileNames.add(factoryCertifiedDocument);
    		}
    	}
		return factoryFileNames;
	}

	public boolean isPaymentChange() {
		return paymentChange;
	}

	public void setPaymentChange(boolean paymentChange) {
		this.paymentChange = paymentChange;
	}

	public void setFactoryFileNames(List<String> factoryFileNames) {
		this.factoryFileNames = factoryFileNames;
	}


	public List<PcsSupplierManufacturerVO> getManufacturerList() {
		return manufacturerList;
	}


	public Integer getForbidPayment() {
		return forbidPayment;
	}

	public void setForbidPayment(Integer forbidPayment) {
		this.forbidPayment = forbidPayment;
	}

	public void setManufacturerList(List<PcsSupplierManufacturerVO> manufacturerList) {
		this.manufacturerList = manufacturerList;
	}




	public List<Long> getManufacturers() {
		return manufacturers;
	}




	public void setManufacturers(List<Long> manufacturers) {
		this.manufacturers = manufacturers;
	}




	public String getFactoryCertifiedDocuments() {
		return factoryCertifiedDocuments;
	}



	public void setFactoryCertifiedDocuments(String factoryCertifiedDocuments) {
		this.factoryCertifiedDocuments = factoryCertifiedDocuments;
	}


	public Long getLastApprover() {
		return lastApprover;
	}

	public void setLastApprover(Long lastApprover) {
		this.lastApprover = lastApprover;
	}

	public String getLastApproverName() {
		return lastApproverName;
	}

	public void setLastApproverName(String lastApproverName) {
		this.lastApproverName = lastApproverName;
	}

	public String getLastAuditRemark() {
		return lastAuditRemark;
	}

	public void setLastAuditRemark(String lastAuditRemark) {
		this.lastAuditRemark = lastAuditRemark;
	}

	public Date getLastAuditTime() {
		return lastAuditTime;
	}

	public void setLastAuditTime(Date lastAuditTime) {
		this.lastAuditTime = lastAuditTime;
	}

	public Date getLastSubmitTime() {
		return lastSubmitTime;
	}

	public void setLastSubmitTime(Date lastSubmitTime) {
		this.lastSubmitTime = lastSubmitTime;
	}
    
	public Integer getSupplierType() {
		return supplierType;
	}

	public void setSupplierType(Integer supplierType) {
		this.supplierType = supplierType;
	}

	public String getSupplierTypeName() {
		return SupplierTypeEnum.getDesc(this.supplierType);
	}

	public List<String> getCategoryList() {
		return categoryList;
	}

	public void setCategoryList(List<String> categoryList) {
		this.categoryList = categoryList;
	}

	public List<String> getPurchaseCategoryList() {
		return purchaseCategoryList;
	}

	public void setPurchaseCategoryList(List<String> purchaseCategoryList) {
		this.purchaseCategoryList = purchaseCategoryList;
	}

	public Integer getPaymentTermType() {
		return paymentTermType;
	}

	public void setPaymentTermType(Integer paymentTermType) {
		this.paymentTermType = paymentTermType;
	}

	public Integer getPaymentTermTypeName() {
		return paymentTermTypeName;
	}

	public void setPaymentTermTypeName(Integer paymentTermTypeName) {
		this.paymentTermTypeName = paymentTermTypeName;
	}

	public boolean isSaveDraft() {
		return saveDraft;
	}

	public void setSaveDraft(boolean saveDraft) {
		this.saveDraft = saveDraft;
	}

	public Long getCreator() {
		return creator;
	}

	public void setCreator(Long creator) {
		this.creator = creator;
	}

	public Long getLastModifier() {
		return lastModifier;
	}

	public void setLastModifier(Long lastModifier) {
		this.lastModifier = lastModifier;
	}

	public String getCreatorCN() {
		return creatorCN;
	}

	public void setCreatorCN(String creatorCN) {
		this.creatorCN = creatorCN;
	}

	public String getLastModifierCN() {
		return lastModifierCN;
	}

	public void setLastModifierCN(String lastModifierCN) {
		this.lastModifierCN = lastModifierCN;
	}

	public BigDecimal getInvoiceTaxRate() {
		return invoiceTaxRate;
	}

	public void setInvoiceTaxRate(BigDecimal invoiceTaxRate) {
		this.invoiceTaxRate = invoiceTaxRate;
	}

	public Integer getTaxpayerType() {
		return taxpayerType;
	}

	public void setTaxpayerType(Integer taxpayerType) {
		this.taxpayerType = taxpayerType;
	}

	public String getTaxpayerTypeName() {
		return PcsTaxpayerTypeEnum.getNameByCode(this.taxpayerType);
	}

	public Integer getOptType() {
		return optType;
	}

	public void setOptType(Integer optType) {
		this.optType = optType;
	}

	public Integer getSupplierOrderStatus() {
		return supplierOrderStatus;
	}

	public void setSupplierOrderStatus(Integer supplierOrderStatus) {
		this.supplierOrderStatus = supplierOrderStatus;
	}

	public String getSupplierOrderStatusName() {
		return PcsSupplierOrderStatusEnum.getValueByKey(this.supplierOrderStatus);
	}

	public Date getFinishedTime() {
		return finishedTime;
	}

	public void setFinishedTime(Date finishedTime) {
		this.finishedTime = finishedTime;
	}

	public Integer getIsNational() {
		return isNational;
	}

	public void setIsNational(Integer isNational) {
		this.isNational = isNational;
	}

	public Integer getBusinessLicense() {
		return businessLicense;
	}

	public void setBusinessLicense(Integer businessLicense) {
		this.businessLicense = businessLicense;
	}

	public Integer getOrgCodeCertificate() {
		return orgCodeCertificate;
	}

	public void setOrgCodeCertificate(Integer orgCodeCertificate) {
		this.orgCodeCertificate = orgCodeCertificate;
	}

	public Integer getTaxRegistrationCertificate() {
		return taxRegistrationCertificate;
	}

	public void setTaxRegistrationCertificate(Integer taxRegistrationCertificate) {
		this.taxRegistrationCertificate = taxRegistrationCertificate;
	}

	public Integer getTaxpayerCertificate() {
		return taxpayerCertificate;
	}

	public void setTaxpayerCertificate(Integer taxpayerCertificate) {
		this.taxpayerCertificate = taxpayerCertificate;
	}

	public Integer getRegistrationCertificate() {
		return registrationCertificate;
	}

	public void setRegistrationCertificate(Integer registrationCertificate) {
		this.registrationCertificate = registrationCertificate;
	}

	// auto generate
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNameCn() {
        return nameCn;
    }

    public void setNameCn(String nameCn) {
        this.nameCn = nameCn;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getSupplierStatus() {
        return supplierStatus;
    }

    public void setSupplierStatus(Integer supplierStatus) {
        this.supplierStatus = supplierStatus;
    }

	public String getSupplierStatusName() {
		return SWITCH_STATUS.get(Integer.valueOf(1).equals(this.supplierStatus));
	}

	public String getNonSupplierStatusName() {
		return SWITCH_STATUS.get(!Integer.valueOf(1).equals(this.supplierStatus));
	}

	public Integer getNonSupplierStatus() {
		return Integer.valueOf(1).equals(this.supplierStatus) ? 0:1;
	}

	public String getSupplierStatusRemark() {
		return supplierStatusRemark;
	}

	public void setSupplierStatusRemark(String supplierStatusRemark) {
		this.supplierStatusRemark = supplierStatusRemark;
	}

	public String getContacterName() {
        return contacterName;
    }

    public void setContacterName(String contacterName) {
        this.contacterName = contacterName;
    }

    public Integer getContacterGender() {
        return contacterGender;
    }

    public void setContacterGender(Integer contacterGender) {
        this.contacterGender = contacterGender;
    }

    public String getContacterPhone() {
        return contacterPhone;
    }

    public void setContacterPhone(String contacterPhone) {
        this.contacterPhone = contacterPhone;
    }

    public String getContacterMobile() {
        return contacterMobile;
    }

    public void setContacterMobile(String contacterMobile) {
        this.contacterMobile = contacterMobile;
    }

    public String getContacterEmail() {
        return contacterEmail;
    }

    public void setContacterEmail(String contacterEmail) {
        this.contacterEmail = contacterEmail;
    }

    public Long getDistrictId() {
        return districtId;
    }

    public void setDistrictId(Long districtId) {
        this.districtId = districtId;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getZipCode() {
        return zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getPurchaseCurrencyCode() {
        return purchaseCurrencyCode;
    }

    public void setPurchaseCurrencyCode(String purchaseCurrencyCode) {
        this.purchaseCurrencyCode = purchaseCurrencyCode;
    }

    public String getPurchaseCurrencyDesc() {
        return purchaseCurrencyDesc;
    }

    public void setPurchaseCurrencyDesc(String purchaseCurrencyDesc) {
        this.purchaseCurrencyDesc = purchaseCurrencyDesc;
    }

    public String getPaymentTerm() {
        return paymentTerm;
    }

    public void setPaymentTerm(String paymentTerm) {
        this.paymentTerm = paymentTerm;
    }

    public Integer getFileId() {
        return fileId;
    }

    public void setFileId(Integer fileId) {
        this.fileId = fileId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

	public PcsSupplierAccountInfoVO getAccountInfo() {
		return accountInfo;
	}

	public void setAccountInfo(PcsSupplierAccountInfoVO accountInfo) {
		this.accountInfo = accountInfo;
	}

    public List<PcsSupplierBrandRelationVO> getBrands() {
        return brands;
    }

    public void setBrands(List<PcsSupplierBrandRelationVO> brands) {
        this.brands = brands;
    }

	public String getBrandArr() {
		return brandArr;
	}

	public void setBrandArr(String brandArr) {
		this.brandArr = brandArr;
	}

	public List<PcsSupplierFileVO> getFiles() {
		return files;
	}

	public void setFiles(List<PcsSupplierFileVO> files) {
		this.files = files;
	}

	public String getFullAddress() {
		return fullAddress;
	}

	public void setFullAddress(String fullAddress) {
		this.fullAddress = fullAddress;
	}

	public Integer getSupplierKind() {
		return supplierKind;
	}

	public void setSupplierKind(Integer supplierKind) {
		this.supplierKind = supplierKind;
	}

	public String getSupplierKindName() {
		return SupplierKindEnum.getNameByCode(this.supplierKind);
	}

	public List<Long> getSupplyCityList() {
		return supplyCityList;
	}

	public void setSupplyCityList(List<Long> supplyCityList) {
		this.supplyCityList = supplyCityList;
	}

	public List<PcsSupplierRebatesConfigVO> getRebatesConfigVOS() {
		return rebatesConfigVOS;
	}

	public void setRebatesConfigVOS(List<PcsSupplierRebatesConfigVO> rebatesConfigVOS) {
		this.rebatesConfigVOS = rebatesConfigVOS;
	}

	public Boolean getHavePermission() {
		return havePermission;
	}
	public void setHavePermission(Boolean havePermission) {
		this.havePermission = havePermission;
	}

	public Boolean getCurrUserCanAudit() {
		return currUserCanAudit;
	}

	public void setCurrUserCanAudit(Boolean currUserCanAudit) {
		this.currUserCanAudit = currUserCanAudit;
	}

	public boolean isNeedAuditSupplierStatus() {
		return needAuditSupplierStatus;
	}

	public void setNeedAuditSupplierStatus(boolean needAuditSupplierStatus) {
		this.needAuditSupplierStatus = needAuditSupplierStatus;
	}

	public List<PcsSupplierContactVO> getSupplierContactVOs() {
        return supplierContactVOs;
    }

    public void setSupplierContactVOs(List<PcsSupplierContactVO> supplierContactVOs) {
        this.supplierContactVOs = supplierContactVOs;
    }

	public boolean isOptRebatesFlag() {
		return optRebatesFlag;
	}

	public void setOptRebatesFlag(boolean optRebatesFlag) {
		this.optRebatesFlag = optRebatesFlag;
	}

	public BigDecimal getRatio() {
		return ratio;
	}

	public void setRatio(BigDecimal ratio) {
		this.ratio = ratio;
	}

	public String getCountryName() {
		return countryName;
	}

	public void setCountryName(String countryName) {
		this.countryName = countryName;
	}

	public List<PcsSupplierPaymentVO> getPcsSupplierPaymentVOList() {
		return pcsSupplierPaymentVOList;
	}

	public void setPcsSupplierPaymentVOList(List<PcsSupplierPaymentVO> pcsSupplierPaymentVOList) {
		this.pcsSupplierPaymentVOList = pcsSupplierPaymentVOList;
	}

	//审核完成
	public List<PcsSupplierAuditRecordVO> getSupplierAuditRecordVOS() {
		return supplierAuditRecordVOS;
	}

	public void setSupplierAuditRecordVOS(List<PcsSupplierAuditRecordVO> supplierAuditRecordVOS) {
		this.supplierAuditRecordVOS = supplierAuditRecordVOS;
	}

	public Integer getForbidPo() {
		return forbidPo;
	}

	public void setForbidPo(Integer forbidPo) {
		this.forbidPo = forbidPo;
	}


}