package com.thebeastshop.pegasus.merchandise.enums;


import java.util.*;

public enum SkuCustomPrintTemplateEnum {

    NONSUPPORT((short)0, "不支持"),
    HANGTAG((short)1, "吊牌定制"),
    VALENTINE_DAY_LOVE_TAG((short)2, "情人节爱心吊牌"),
    LILY_VALLEY_TAG((short)3, "铃兰灯吊牌"),
    CHERRY_BLOSSOM_DIFFUSER_SMALL((short)4, "樱花散香器（小号）"),
    CHERRY_BLOSSOM_DIFFUSER_LARGE((short)5, "樱花散香器（大号）");

    public final Short code;
    public final String desc;

    public static final List<SkuCustomPrintTemplateEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    SkuCustomPrintTemplateEnum(final Short code, final String desc) {
        this.code = code;
        this.desc = desc;
    }

    public final static List<Map<String, Object>> listMapEnum() {
        List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        for (SkuCustomPrintTemplateEnum skuStatusEnum : SkuCustomPrintTemplateEnum.values()) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("value", skuStatusEnum.code);
            map.put("name", skuStatusEnum.desc);
            listMap.add(map);
        }
        return listMap;
    }

    public static String getDesc(short status) {
        for (SkuCustomPrintTemplateEnum c : ALL) {
            if (c.getCode() == status) {
                return c.desc;
            }
        }
        return null;
    }

    public static Short getCode(String desc) {
        for (SkuCustomPrintTemplateEnum c : ALL) {
            if (c.desc.equals(desc)) {
                return c.code;
            }
        }
        return null;
    }

    public Short getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }


}
