package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;
import java.util.Map;

import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.cond.PsSpvCond;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;

/**
 * @author gongjun
 * @since 2016-11-03
 */
public interface McPsSpvService {

    /**
     * 根据产品ID获取SPV列表
     * @param prodId
     * @return
     */
    List<PsSpvVO> findByProdId(Long prodId);


    PsSpvVO findSpvBySkuCode(String prodCode, String skuCode);

    PsSpvVO findSpvBySkuCodeWithStock(String prodCode, String skuCode,String chnCode);

    /**
     * 根据产品ID获取SPV列表，并关联SKU
     * @param prodId
     * @return
     */
    List<PsSpvVO> findWithSkuByProdId(Long prodId);

    /**
     * 根据SPV ID获取SPV
     * @param spvId
     * @return
     */
    PsSpvVO findBySpvId(Long spvId);

    /**
     * 获取SPV，并关联SKU列表
     * @param spvId
     * @return
     */
    PsSpvVO findWithSkuBySpvId(Long spvId);

    /**
     * 获取SPV，并关联SKU列表
     * @param spvIds
     * @return
     */
    List<PsSpvVO> findWithSkuBySpvIds(List<Long> spvIds);


    PsSpvVO findWithSkuAndStockBySpvId(Long spvId, String chnCode);

    /**
     * 根据ID批量查询SPV列表
     * @param spvIds
     * @return
     */
    List<PsSpvVO> findBySpvIds(List<Long> spvIds);

    /**
     * 根据ID批量查询SPV库存列表
     * @param spvIds
     * @return
     */
    List<PsSpvVO> findBySpvIdsWithStock(List<Long> spvIds,String chnCode);


    Map<Long, PsSpvVO> mapBySpvIds(List<Long> spvIds);

    Map<Long, PsSpvVO> mapBySpvIdsWithStock(List<Long> spvIds,String chnCode);

    List<PsSpvVO> findByCond(PsSpvCond cond);

    /**
     * 通过spvIds获取已匹配好活动并计算好折扣价的spvVO集合
     * @param spvIds
     * @param cond
     * @return
     */
    List<PsSpvVO> findBySpvIds(List<Long> spvIds, PsMatchCampaignCond cond);

    /**
     * 通过spvIds获取已匹配好活动并计算好折扣价的spvVO集合
     * @param spvIds
     * @param cond
     * @return
     */
    List<PsSpvVO> findBySpvIdsWithStock(List<Long> spvIds, PsMatchCampaignCond cond,String chnCode);

    /**
     * 通过spvIds获取已匹配好活动并计算好折扣价的spvVO集合
     * @param spvIds
     * @param cond
     * @return
     */
    Map<Long, PsSpvVO> mapBySpvIds(List<Long> spvIds, PsMatchCampaignCond cond);
}
