package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 供应商类型
 * @author Gary
 *
 */
public enum SupplierTypeEnum {

	DISTRIBUTOR(1, "分销商"),
	BRAND_SIDE(2, "品牌方"),
	FACTORY(3, "工厂");

	public final Integer status;
	public final String desc;

	public static final List<SupplierTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private SupplierTypeEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(Integer status) {
        for (SupplierTypeEnum c : SupplierTypeEnum.values()) {
            if (c.getStatus().equals(status)) {
                return c.desc;
            }
        }
        return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}
	
	
}
