package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;

/**
 * 纳税人类型
 *
 */
public enum PcsTaxpayerTypeEnum {

    /**
     * 纳税人类型
     */
    SMALL(0, "小规模纳税人"),
    GENERAL(1, "一般纳税人"),
    OVERSEAS_SUPPLIERS(2, "海外供应商")
    ;

    private Integer code;

    private String name;

    PcsTaxpayerTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static PcsTaxpayerTypeEnum getEnumByCode(Integer code){
        return Arrays.stream(PcsTaxpayerTypeEnum.values()).filter(item->item.getCode().equals(code))
                .findAny().orElse(null);
    }

    public static String getNameByCode(Integer code) {
        PcsTaxpayerTypeEnum originEnum = getEnumByCode(code);
        return originEnum == null ? "":originEnum.getName();
    }
}
