package com.thebeastshop.pegasus.merchandise.enums;

public enum PcsSkuCustomsRecordTypeEnum {

	NOTPASS(1,"不通过"),
	STAY(2,"待备案"),
	INRECORD9(3,"备案中"),
	PASS(4,"备案通过");
	
	private Integer code;

    private String name;
    
    PcsSkuCustomsRecordTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public boolean equals(PcsSkuCustomsRecordTypeEnum typeEnum) {
        if (typeEnum == null) return false;
        return code.equals(typeEnum.getCode());
    }

    public boolean equals(Integer code) {
        if (code == null) return false;
        return this.code.equals(code);
    }

    public static PcsSkuCustomsRecordTypeEnum getEnumByCode(Integer code) {
        for (PcsSkuCustomsRecordTypeEnum e : PcsSkuCustomsRecordTypeEnum.values()) {
            if (e.code == code) {
                return e;
            }
        }
        return null;
    }
}
