package com.thebeastshop.pegasus.merchandise.constants;

import java.util.*;

/**
 * SKU相关常量
 * @author gongjun
 */
public class PcsSkuConstants {

    // self
    // skuStatus
    /**
     * sku状态~价格待审核
     */
    public static final Integer SKU_STATUS_WAITING_VERIFY = 1;
    /**
     * sku状态~草稿
     */
    public static final Integer SKU_STATUS_DRAFT = 0;
    /**
     * sku状态~已驳回
     */
    public static final Integer SKU_STATUS_REJECT = 2;
    /**
     * sku状态~可用
     */
    public static final Integer SKU_STATUS_ABLE = 9;
    // skuType
    /**
     * sku类型~原材料
     */
    public static final Integer SKU_TYPE_MATERIAL = 1;
    /**
     * sku类型~半成品
     */
    public static final Integer SKU_TYPE_SEMIFINISHED_PRODUCT = 2;
    /**
     * sku类型~成品
     */
    public static final Integer SKU_TYPE_FINISHED_PRODUCT = 3;
    // serviceLevel
    /**
     * 产品重要性等级(1,2,3,4)
     */
    public static final Integer SERVICE_LEVEL_1 = 1;
    public static final Integer SERVICE_LEVEL_2 = 2;
    public static final Integer SERVICE_LEVEL_3 = 3;
    public static final Integer SERVICE_LEVEL_4 = 4;

    public static final List<Integer> listYears() {
        int initYear = 2015;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(Calendar.YEAR);
        int num = year - initYear + 2;
        List<Integer> yearList = new ArrayList<Integer>();
        for (int i = num - 1; i >= 0; i --) {
            yearList.add(initYear + i);
        }
        return yearList;
    }

    public static final String[] SEASONS = {"春", "夏", "秋", "冬"};
    public static final List<Map<String, String>> SEASONS_MAP_LIST = new ArrayList<Map<String, String>>();

    static {
        for (String season : SEASONS) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("id", season);
            map.put("name", season);
            SEASONS_MAP_LIST.add(map);
        }
    }

}
