package com.thebeastshop.pegasus.merchandise.IService;

import java.util.List;
import java.util.Map;

import com.thebeastshop.scm.po.LotteryActivity;
import com.thebeastshop.scm.vo.lottery.DrawResultException;
import com.thebeastshop.scm.vo.lottery.LotteryActivityDrawParamVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityDrawResultVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityEditVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivityRecordVO;
import com.thebeastshop.scm.vo.lottery.LotteryActivitySaveVO;

/**
 * 抽奖接口
 * @author donghui
 */
public interface ILotteryActivityService {
	List<LotteryActivity> findAll();
	
	void save(LotteryActivitySaveVO vo) ;
	
	LotteryActivityEditVO byLotteryActivityId(Integer lotteryActivityId);
	
	/**
	 * 查找中奖清单人员
	 * @param awardId 奖项ID
	 * @return
	 */
	List<Map> winListByAwardId(Integer awardId);
	
	/**
	 * 查询中奖的记录
	 * @param memberId 用户ID
	 * @param lotteryActivityId	抽奖活动ID
	 */
	List<LotteryActivityRecordVO> winList(Integer memberId, Integer lotteryActivityId);
	
	/**
	 * 查询抽奖记录
	 * @param lotteryActivityPrizeRecordId 抽奖记录ID
	 * @return
	 */
	LotteryActivityRecordVO byLotteryActivityPrizeRecordId(Integer lotteryActivityPrizeRecordId);
	
	/**
	 * 最近的中奖信息滚动条
	 * @return
	 */
	List<LotteryActivityRecordVO> queryLastWinRecord(Integer limit);
	
	/**
	 * 抽奖方法
	 * @param memberId 用户ID
	 * @param lotteryActivityId　抽奖活动ID
	 * @param systemId 系统ID(当抽奖限制为按系统ID时)
	 * @param isCheck 是否验证抽奖规则
	 * @return
	 */
	LotteryActivityDrawResultVO drawLottery(LotteryActivityDrawParamVO paramVO);
	
	/**
	 * 校验抽奖规则
	 * @param memberId 用户ID
	 * @param lotteryActivityId　抽奖活动ID
	 * @param systemId 系统ID(当抽奖限制为按系统ID时)
	 * @return null表示成功,反之表示失败原因
	 */
	DrawResultException checkDrawLottery(Integer memberId, Integer lotteryActivityId, String sysId);
}
