package com.thebeastshop.pegasus.merchandise.enums;

/**
 * 供应商审核状态
 * -1驳回 0草稿 1品类经理审批 2财务审批 3审核完成
 */
public enum PcsSupplierOrderStatusEnum {
    REJECT(-1, "驳回"),
    DRAFT(0, "草稿"),
    MANAGER_AUDIT(1, "品类经理审批"),
    FINANCE_AUDIT(2, "财务审批"),
    AUDIT_COMPLETED(3, "审核完成")
    ;
    private Integer type;
    private String desc;

    PcsSupplierOrderStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static PcsSupplierOrderStatusEnum getEnumByType(Integer type) {
        for (PcsSupplierOrderStatusEnum dynmTypeEnum : PcsSupplierOrderStatusEnum.values()) {
            if (dynmTypeEnum.getType().equals(type)) {
                return dynmTypeEnum;
            }
        }
        return null;
    }
}
