package com.thebeastshop.pegasus.merchandise.enums;

import java.util.*;

/**
 * SKU特殊商品种类
 */
public enum PcsSkuSpecialVarietyEnum {

    GENERAL(1, "普通商品"),
    GIFT_CARD(2, "礼品卡"),
    MYSTERY_BOX(3, "盲盒商品");

    public final Integer type;
    public final String desc;

    public static final List<PcsSkuSpecialVarietyEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    PcsSkuSpecialVarietyEnum(final Integer status, final String desc) {
        this.type = status;
        this.desc = desc;
    }

    public final static List<Map<String, Object>> listMapEnum() {
        List<Map<String, Object>> listMap = new ArrayList<Map<String, Object>>();
        for (PcsSkuSpecialVarietyEnum pcsSkuSpecialVarietyEnum : PcsSkuSpecialVarietyEnum.values()) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("type", pcsSkuSpecialVarietyEnum.type);
            map.put("desc", pcsSkuSpecialVarietyEnum.desc);
            listMap.add(map);
        }
        return listMap;
    }

    // 普通方法
    public static String getDesc(Integer status) {
        for (PcsSkuSpecialVarietyEnum c : ALL) {
            if (c.type == status) {
                return c.desc;
            }
        }
        return null;
    }

    public final static Integer getTypeByDesc(String desc) {
        Integer statusVal = null;
        for (PcsSkuSpecialVarietyEnum skuSpecialVarietyEnum : values()) {
            if (skuSpecialVarietyEnum.desc.equals(desc)) {
                statusVal = skuSpecialVarietyEnum.type;
                break;
            }
        }
        return statusVal;
    }


    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
