package com.thebeastshop.pegasus.merchandise.enums;

import com.thebeastshop.common.enums.CodeEnum;

import java.util.Arrays;

public enum PcsSkuFlowerKindEnum implements CodeEnum<Integer> {
    MAIN_FLOWER(1,"主花"),
    MATCH_FLOWER(2,"配花"),
    MATCH_LEAVE(3,"配叶"),
    MATCH_FRUIT(4,"配果"),
    GREEN_PLANT(5,"绿植"),
    CONSUMABLE(6,"耗材"),
    OTHER(7,"其他");

    private Integer code;

    private String name;

    PcsSkuFlowerKindEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static PcsSkuFlowerKindEnum valueOf(Integer code){
        return Arrays.stream(PcsSkuFlowerKindEnum.values()).filter(itemEnum->itemEnum.getCode().equals(code)).findAny().orElse(null);
    }
}
