package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 组合商品审批状态 枚举
 */
public enum ApproveProdStatusEnum {
  MANAGER_APPROVE(Integer.valueOf(1), "经理审批中"),
  NO_APPROVE(Integer.valueOf(2), "审批不通过"),
  FINANCE_APPROVE(Integer.valueOf(3), "财务审批中"),
  SUCCESS_APPROVE(Integer.valueOf(9), "审批通过");

  private final Integer id;
  private final String name;
  public static final List<ApproveProdStatusEnum> ALL;

  private ApproveProdStatusEnum(Integer id, String name) {
    this.id = id;
    this.name = name;
  }

  public Integer getId() {
    return this.id;
  }

  public String getName() {
    return this.name;
  }

  public static ApproveProdStatusEnum getEnumById(Integer id) {
    ApproveProdStatusEnum[] var1 = values();
    int var2 = var1.length;

    for(int var3 = 0; var3 < var2; ++var3) {
      ApproveProdStatusEnum item = var1[var3];
      if(item.getId().equals(id)) {
        return item;
      }
    }

    return null;
  }

  static {
    ALL = Collections.unmodifiableList(Arrays.asList(values()));
  }

}
