package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.common.utils.ExcelColumn;
import com.thebeastshop.common.utils.ExcelSheet;
import com.thebeastshop.common.utils.ExcelTemplate;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@ExcelTemplate
@ExcelSheet(value = "Sheet1")
public class PcsSkuSimpleVO implements Serializable {

  private static final long serialVersionUID = 4673689290842218914L;

  @ExcelColumn(name="SKU")
  @NotNull
  private String skuCode;

  private String skuNameCN;

  private BigDecimal salesPrice;

  public String getSkuCode() {
    return skuCode;
  }

  public void setSkuCode(String skuCode) {
    this.skuCode = skuCode;
  }

  public String getSkuNameCN() {
    return skuNameCN;
  }

  public void setSkuNameCN(String skuNameCN) {
    this.skuNameCN = skuNameCN;
  }

  public BigDecimal getSalesPrice() {
    return salesPrice;
  }

  public void setSalesPrice(BigDecimal salesPrice) {
    this.salesPrice = salesPrice;
  }
}
