package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2019/8/14 11:49
 * 人工推荐选购页
 */
public enum RecommendTypeEnum {

    MANUAL(1, "人工推荐"),
    ALIYUN(2, "阿里云推荐"),
    FILLING_POSITION(3, "补位推荐"),
    ;

    private final int id;

    private final String name;

    public static final List<RecommendTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    RecommendTypeEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static RecommendTypeEnum getById(int id) {
        for (RecommendTypeEnum e : RecommendTypeEnum.values()) {
            if (e.getId() == id) {
                return e;
            }
        }
        return null;
    }

}
