package com.thebeastshop.pegasus.merchandise.IService;

import java.util.List;
import java.util.Map;

import com.thebeastshop.common.Pagination;
import com.thebeastshop.scm.cond.InterestGoodsCond;
import com.thebeastshop.scm.po.InterestGoods;
import com.thebeastshop.scm.vo.interest.InterestGoodsGetVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsProvideVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsSaveVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsSkuVO;
import com.thebeastshop.scm.vo.interest.InterestGoodsVO;


/**
 * 商品权益API
 * @Class Name IInterestGoodsService
 * @Author Xiang.Gao
 * @Create In 2017-5-5
 */
public interface IInterestGoodsService {
	
	/**
	 * 商品权益查询
	 * @Methods Name list
	 * @Create In 2017-5-9 By Xiang.Gao
	 */
	@SuppressWarnings("rawtypes")
	public List<Map> list(InterestGoodsCond cond);

	public Pagination<Map> list2(InterestGoodsCond cond);

	/**
	 * 查询单个商品权益
	 * @Methods Name selectInterestById
	 * @Create In 2017-5-9 By Xiang.Gao
	 */
	public InterestGoods selectInterestById(Integer interestGoodsId);
	
	/**
	 * 查询商品权益及SKU信息
	 * @Methods Name selectInterestGoodsSku
	 * @Create In 2017-5-9 By Xiang.Gao
	 */
	public InterestGoodsVO selectInterestGoodsSku(Integer integerGoodsId);
	
	/**
	 * 查询商品权益数量
	 * @Methods Name sumQuantityByInterestId
	 * @Create In 2017-5-9 By Xiang.Gao
	 */
	public int sumQuantityByInterestId(Integer interestGoodsId); 
	
	/**
	 * 保存商品权益
	 * @Methods Name save
	 * @Create In 2017-5-9 By Xiang.Gao
	 */
	public Integer save(InterestGoodsSaveVO vo);
	
	/**
	 * 删除商品权益
	 * @Methods Name delete
	 * @Create In 2017-5-9 By Xiang.Gao
	 */
	void delete(int interestGoodsId);
	
	/**-----------------------------------   以下接口提供给外部调用       --------------------------*/
	
	/**
	 * 获取商品权益
	 * @Methods Name getInterestGoods
	 * @Create In 2017-5-9 By Xiang.Gao
	 */
	public InterestGoodsGetVO getInterestGoods(Integer memberId, Integer interestGoodsId);
	
	/**
	 * 兑换商品权益
	 * @Methods Name cash
	 * @Create In 2017-3-2 By Xiang.Gao
	 */
	public void cash(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOList);
	
	/**
	 * 返还商品权益
	 * @Methods Name back
	 * @Create In 2017-5-9 By Xiang.Gao
	 */
	public void back(Integer memberId,List<InterestGoodsSkuVO> interestGoodsSkuVOList);
	
	/**
	 * 更新用户一个商品权益ID下的权益SKU记录(多规则商品)
	 * @param memberId 会员ID
	 * @param sourceInterestSkuId 原来的权益sku ID
	 * @param destInterestSkuId 更换的目标权益sku ID
	 * @return 更新是否成功
	 */
	public boolean changeInterestGoodsSku(Integer memberId, Integer sourceInterestGoodsSkuId, Integer destInterestGoodsSkuId);
	
	/**
	 * 获取已兑取的数量
	 * @Methods Name getCashQuantity
	 * @Create In 2017-2-27 By Xiang.Gao
	 */
	public Map<Integer, Integer> getCashQuantity(List<Integer> interestGoodsSkuIds);
	
	/**
	 * 获取商品权益领取记录
	 * @Methods Name getProvideRecord
	 * @Create In 2017-5-5 By Xiang.Gao
	 */
	public List<InterestGoodsProvideVO> getProvideRecord(InterestGoodsCond cond);
	
	/**
	 * 查询指定日期后到期的商品权益
	 * @Methods Name getPreExpiration
	 * @Create In 2017-4-20 By Xiang.Gao
	 */
	public List<InterestGoodsGetVO> getPreExpiration(Integer day);
	
	/**
	 * 更改商品权益所属用户(会员合并)
	 * @Methods Name changeMember
	 * @Create In 2017-9-1 By Xiang.Gao
	 * @param sourceMemberId
	 * @param targetMemberId
	 * @return int
	 */
	public int changeMember(Integer sourceMemberId, Integer targetMemberId);
	
	/**
	 * 修改过期的商品权益
	 * @Methods Name updateOverdue
	 * @Create In 2017-9-28 By Xiang.Gao void
	 */
	public void updateOverdue();
	
}
