package com.thebeastshop.pegasus.merchandise.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.collections.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 *
 * @author gongjun
 * @since 2016-10-13
 */
public class PsSpvVO extends PsBaseVO {

    private Long spvId;
    /**
     * 组合原价
     */
    private BigDecimal originalPrice;
    /**
     * 售价
     */
    private BigDecimal salesPrice;

    /**
     * 折扣价格
     */
    private BigDecimal discountPrice;

    /**
     * 生日折扣价格
     */
    private BigDecimal bdDiscountPrice;

    /**
     * PRODUCT ID
     */
    private Long productId;
    /**
     * PRODUCT编码
     */
    private String productCode;
    /**
     * PRODUCT名称
     */
    private String productName;
    /**
     * 成本价
     */
    private BigDecimal costPrice;
    /**
     * 是否组合
     */
    private Boolean combined;

    /**
     * 对应属性值JSON字符串
     */
    private String attrs;

    /**
     * SPV对应属性值对
     */
    private List<PsAttributeValuePairVO> attributeValuePairList;

    /**
     * SPV对应属性值 [AttrId -> AttrValueId]
     */
    private Map<Long, Long> attrValues;

    /**
     * 最小起售数
     */
    private Integer minAmount;

    /**
     * 单品SKU CODE
     */
    private String skuCode;

    /**
     * 单品SKU
     */
    private PsSkuVO skuVO;

    /**
     * SKU组合列表
     */
    private List<PsSkuCombinationVO> skuCombinationList;

    /**
     * 预告活动价格
     */
    private BigDecimal advancePrice;
    /**
     * SKU维度活动列表
     */
    private List<PsCampaignVO> campaignList = new ArrayList<>();

    /**
     * 预告活动
     */
    private List<PsCampaignVO> advanceCampaignList = new ArrayList<>();

    /**
     * 价格计算结果
     */
    private List<PriceCalResultVO> priceCalResults;

    /**
     * 生日折扣价格计算结果
     */
    private List<PriceCalResultVO> bdPriceCalResults;

    /**
     * SKU库存信息
     */
    private PsStockVO psStockVO;

    private PsStockVO psFurnitureStockVO;

    private PsPresaleSaleStockVO psPresaleSaleStockVO;

    private Boolean isNewMember = false;//是否是新人专享

    /**
     * 非组合商品后端主类目编号
     */
    private Long categoryId;

    private String bu;

    public Long getSpvId() {
        return spvId;
    }

    public void setSpvId(Long spvId) {
        this.spvId = spvId;
    }

    public BigDecimal getSalesPrice() {
        return salesPrice;
    }

    public void setSalesPrice(BigDecimal salesPrice) {
        this.salesPrice = salesPrice;
    }

    public BigDecimal getDiscountPrice() {
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public BigDecimal getCostPrice() {
        return costPrice;
    }

    public void setCostPrice(BigDecimal costPrice) {
        this.costPrice = costPrice;
    }

    public Boolean getCombined() {
        return combined;
    }

    public void setCombined(Boolean combined) {
        this.combined = combined;
    }

    public String getAttrs() {
        return attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public List<PsAttributeValuePairVO> getAttributeValuePairList() {
        return attributeValuePairList;
    }

    public void setAttributeValuePairList(List<PsAttributeValuePairVO> attributeValuePairList) {
        this.attributeValuePairList = attributeValuePairList;
    }

    public Map<Long, Long> getAttrValues() {
        return attrValues;
    }

    public void setAttrValues(Map<Long, Long> attrValues) {
        this.attrValues = attrValues;
    }


    public Integer getMinAmount() {
        return minAmount;
    }

    public void setMinAmount(Integer minAmount) {
        this.minAmount = minAmount;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public PsSkuVO getSkuVO() {
        return skuVO;
    }

    public void setSkuVO(PsSkuVO skuVO) {
        this.skuVO = skuVO;
    }

    public List<PsSkuCombinationVO> getSkuCombinationList() {
        return skuCombinationList;
    }

    public void setSkuCombinationList(List<PsSkuCombinationVO> skuCombinationList) {
        this.skuCombinationList = skuCombinationList;
    }

    public BigDecimal getAdvancePrice() {
        return advancePrice;
    }

    public void setAdvancePrice(BigDecimal advancePrice) {
        this.advancePrice = advancePrice;
    }

    public List<PsCampaignVO> getCampaignList() {
        return campaignList;
    }

    public void setCampaignList(List<PsCampaignVO> campaignList) {
        this.campaignList = campaignList;
    }

    public List<PsCampaignVO> getAdvanceCampaignList() {
        return advanceCampaignList;
    }

    public void setAdvanceCampaignList(List<PsCampaignVO> advanceCampaignList) {
        this.advanceCampaignList = advanceCampaignList;
    }

    public List<PriceCalResultVO> getPriceCalResults() {
        return priceCalResults;
    }

    public void setPriceCalResults(List<PriceCalResultVO> priceCalResults) {
        this.priceCalResults = priceCalResults;
    }

    public List<PriceCalResultVO> getBdPriceCalResults() {
        return bdPriceCalResults;
    }

    public void setBdPriceCalResults(List<PriceCalResultVO> bdPriceCalResults) {
        this.bdPriceCalResults = bdPriceCalResults;
    }

    public BigDecimal getBdDiscountPrice() {
        return bdDiscountPrice;
    }

    public void setBdDiscountPrice(BigDecimal bdDiscountPrice) {
        this.bdDiscountPrice = bdDiscountPrice;
    }

    public PsStockVO getPsStockVO() {
        return psStockVO;
    }

    public void setPsStockVO(PsStockVO psStockVO) {
        this.psStockVO = psStockVO;
    }

    public PsPresaleSaleStockVO getPsPresaleSaleStockVO() {
        return psPresaleSaleStockVO;
    }

    public void setPsPresaleSaleStockVO(PsPresaleSaleStockVO psPresaleSaleStockVO) {
        this.psPresaleSaleStockVO = psPresaleSaleStockVO;
    }

    public PsStockVO getPsFurnitureStockVO() {
        return psFurnitureStockVO;
    }

    public void setPsFurnitureStockVO(PsStockVO psFurnitureStockVO) {
        this.psFurnitureStockVO = psFurnitureStockVO;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }

    public BigDecimal getOriginalPrice() {
        return originalPrice;
    }

    public void setOriginalPrice(BigDecimal originalPrice) {
        this.originalPrice = originalPrice;
    }

    @JsonIgnore
    public Integer getCanUseQuantity() {
        Boolean isJit = isJit();
        if (isJit == null) {
            throw new RuntimeException("该SPV没包含SKU，不能查SPV可用数量！");
        };
        if (isJit) {
            return Integer.MAX_VALUE - 100;
        }

        if(combined == null || !combined) {
            if (psPresaleSaleStockVO != null  && psPresaleSaleStockVO.getAvailQuantity() > 0) {
                return psPresaleSaleStockVO.getAvailQuantity();
            }
        }
        if(psStockVO != null){
            return psStockVO.getCanUseQuantity();
        }
        return 0;
    }
    
    @JsonIgnore
    public Integer getCanUseQuantityOffLine() {
        Boolean isJit = isJit();
        if (isJit == null) {
            throw new RuntimeException("该SPV没包含SKU，不能查SPV可用数量！");
        };
        if (isJit) return Integer.MAX_VALUE - 100;
        int canUseQuantity = 0;
        if (psStockVO != null && psStockVO.getCanUseQuantity() != null &&psStockVO.getCanUseQuantity() > 0) {
        	canUseQuantity += psStockVO.getCanUseQuantity();
        }
        if(psFurnitureStockVO != null && psFurnitureStockVO.getCanUseQuantity() != null && psFurnitureStockVO.getCanUseQuantity() > 0){
        	canUseQuantity += psFurnitureStockVO.getCanUseQuantity();
        }
        if (psPresaleSaleStockVO != null && psPresaleSaleStockVO.getAvailQuantity() > 0) {
        	canUseQuantity += psPresaleSaleStockVO.getAvailQuantity();
        }
        return canUseQuantity;
    }

    public Boolean isJit() {
        if (combined) {
            return false;
        }
        if(skuVO == null) {
            return null;
        }
        return skuVO.getIsJit() == 1;
    }

    public Boolean getIsNewMember() {
        if(CollectionUtils.isNotEmpty(campaignList)){
            for(PsCampaignVO campaignVO : campaignList){
                if("01".equals(campaignVO.getMemberType())){
                    return true;
                }
            }
        }
        return false;
    }

    public String getBu() {
        return bu;
    }

    public void setBu(String bu) {
        this.bu = bu;
    }

//    public PsStockEnoughVO checkStock() {
//        Boolean isJit = isJit();
//        if (isJit == null) return null;
//        PsStockEnoughVO enoughVO = new PsStockEnoughVO();
//        Integer quantity = getCanUseQuantity();
//        if (isJit) {
//            enoughVO.setIsJit(true);
//            enoughVO.setCanUseQuanity(10000);
//        }
//        enoughVO.setCanUseQuanity(quantity);
//        return enoughVO;
//    }
}
