package com.thebeastshop.pegasus.merchandise.vo;

import com.thebeastshop.common.utils.EmptyUtil;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @ClassName PcsSupplierContactVO
 * @Description TODO
 * @Author Administrator
 * @Date 2019/7/29 14:52
 * @Version 1.0.0
 **/
public class PcsSupplierContactVO implements Serializable {

    private Long id;

    private Long supplierId;

    private String name;

    private String phone;

    private String mobilePhone;

    private String email;

    private String position;

    private Integer gender;

    private String genderStr;

    private Date createTime;

    public static final Integer GENDER_MALE = 1; // 性别：男
    public static final Integer GENDER_FEMALE = 2;  // 性别：女
    public static final Integer GENDER_SECRECY = 0;  // 性别：保密
    public static final Map<Integer, String> GENDER_MAP = new LinkedHashMap<Integer, String>(){{
        put(GENDER_MALE, "男");
        put(GENDER_FEMALE, "女");
        put(GENDER_SECRECY, "保密");
    }};

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public Integer getGender() {
        return gender;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public String getGenderStr() {
        if (EmptyUtil.isEmpty(genderStr) && EmptyUtil.isNotEmpty(gender)){
            genderStr = GENDER_MAP.get(gender);
        }
        return genderStr;
    }

    public void setGenderStr(String genderStr) {
        this.genderStr = genderStr;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
