package com.thebeastshop.pegasus.merchandise.IService;

import com.thebeastshop.pegasus.merchandise.cond.OpProdDiscountCond;
import com.thebeastshop.pegasus.merchandise.vo.ProdDiscountVO;

import java.util.List;

/**
 * Created by admin on 2017/8/15.
 */
public interface IProdDiscountService {

    //根据商品id,插入
    int addByProdId(Long prodId,Long operatorId,String operatorName);

    //根据商品ids,批量插入
    int batchAddByProdId(List<Long> prodIds,Long operatorId,String operatorName);

    //根据商品code,插入
    int add(String code,Long operatorId,String operatorName);

    //根据商品code,批量插入折扣商品
    int batchAdd(List<String> codes,Long operatorId,String operatorName);

    //检测商品code
    boolean checkProdCode(String code);

    //批量检测商品code
    List<String> checkProdCodes(List<String> codes);

    //批量检测已经存在的折扣商品code
    List<Long> checkExistProdIds(List<Long> productIds);

    //根据商品codes,批量查询商品信息
    List<ProdDiscountVO> queryProdByCodes(List<String> codes);

    int deleteById(Long id);

    int deleteByIds(List<Long> ids);

    //根据商品code，删除
    int deleteByProdCode(String code);

    //根据商品codes,批量删除
    int deleteByProdCodes(List<String> codes);

    //根据条件查询折扣商品
    List<ProdDiscountVO> queryByCond(OpProdDiscountCond cond);

    //根据ids,批量查询
    List<ProdDiscountVO> queryByIds(List<Long> ids);

    //查询所有折扣商品
    List<ProdDiscountVO> queryAllProd();
}
