package com.thebeastshop.pegasus.merchandise.exception;


import com.thebeastshop.common.exception.BaseServiceException;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-04-25 15:04
 */
public class DynmDetailsException extends BaseServiceException {

    public DynmDetailsException(String errorCode) {
        super(errorCode);
    }

    public DynmDetailsException(Exception e, String errorCode, String msg) {
        this(errorCode, processMessage(e, msg));
    }

    public DynmDetailsException(Exception e, DynmDetailsExceptionCode errorCode, String msg) {
        this(errorCode, processMessage(e, msg));
    }


    public DynmDetailsException(Exception e, DynmDetailsExceptionCode errorCode) {
        this(errorCode, processMessage(e, errorCode.getMessage()));
    }


    private static String processMessage(Exception e, String msg) {
        if (e instanceof DynmDetailsException) {
            return msg + " : " + e.getMessage();
        }
        return msg;
    }



    public DynmDetailsException(String errorCode, Throwable cause) {
        super(errorCode, cause);
    }

    public DynmDetailsException(DynmDetailsExceptionCode exceptionCode) {
        super(exceptionCode);
    }

    public DynmDetailsException(DynmDetailsExceptionCode exceptionCode, String msg) {
        super(exceptionCode, msg);
    }

    public DynmDetailsException(DynmDetailsExceptionCode exceptionCode, String msg, Throwable cause) {
        super(exceptionCode, msg, cause);
    }

    public DynmDetailsException(String errorCode, String msg) {
        super(errorCode, msg);
    }

    public DynmDetailsException(String errorCode, String msg, Throwable cause) {
        super(errorCode, msg, cause);
    }

    public String toString() {
        return  "code=[" + this.getErrorCode() + "],msg=[" + this.getMessage() + "]";
    }
}
