package com.thebeastshop.pegasus.merchandise.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**  
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2019/8/14 11:49
 * 人工推荐选购页
 */
public enum ActivityPageTypeEnum {

    CATEGORY_ID(1, "分类ID"),
    CROSS_BORDER(2, "海外直邮"),
    CATEGORY_ID_CROSS(3, "分类ID(仅海淘)"),
    BRAND_ID(4, "品牌ID"),
    LABEL_ID(5, "标签ID"),
    ALL_PROD(6, "全部商品"),
    ;

    private final int id;

    private final String name;

    public static final List<ActivityPageTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

    ActivityPageTypeEnum(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public static ActivityPageTypeEnum getById(int id) {
        for (ActivityPageTypeEnum e : ActivityPageTypeEnum.values()) {
            if (e.getId() == id) {
                return e;
            }
        }
        return null;
    }

}
