package com.thebeastshop.pegasus.merchandise.vo;


import org.springframework.util.ObjectUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PcsSkuProCustomVO implements Serializable {
    private String skuCode;
    private String skuNameCn;
    private String skuName;
    private BigDecimal skuPirce;
    private String skuImg;
    private Long prodId;
    private String prodCode;
    private String prodNameCn;
    private String prodName;
    private String prodDescription;

    List<OpProdDynmDetailsVO> dynmDetails;

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getSkuNameCn() {
        return skuNameCn;
    }

    public void setSkuNameCn(String skuNameCn) {
        this.skuNameCn = skuNameCn;
    }

    public BigDecimal getSkuPirce() {
        return skuPirce;
    }

    public void setSkuPirce(BigDecimal skuPirce) {
        this.skuPirce = skuPirce;
    }

    public String getSkuImg() {
        return skuImg;
    }

    public void setSkuImg(String skuImg) {
        this.skuImg = skuImg;
    }

    public List<OpProdDynmDetailsVO> getDynmDetails() {
        return dynmDetails;
    }

    public void setDynmDetails(List<OpProdDynmDetailsVO> dynmDetails) {
        this.dynmDetails = dynmDetails;
    }

    public Long getProdId() {
        return prodId;
    }

    public void setProdId(Long prodId) {
        this.prodId = prodId;
    }

    public String getProdCode() {
        return prodCode;
    }

    public void setProdCode(String prodCode) {
        this.prodCode = prodCode;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getProdNameCn() {
        return prodNameCn;
    }

    public void setProdNameCn(String prodNameCn) {
        this.prodNameCn = prodNameCn;
    }

    public String getProdName() {
        return prodName;
    }

    public void setProdName(String prodName) {
        this.prodName = prodName;
    }

    public String getProdDescription() {
        return prodDescription;
    }

    public void setProdDescription(String prodDescription) {
        this.prodDescription = prodDescription;
    }

    public Map<Integer,String> getDetailsContentMapByColumnId(){
        Map<Integer,String> voMap = new HashMap<Integer,String>();
        if(dynmDetails != null && dynmDetails.size() > 0){
            for(OpProdDynmDetailsVO vo:dynmDetails){
                if(!ObjectUtils.isEmpty(vo.getDynmcontContent())){
                    if(voMap.get(vo.getDynmcontId()) != null){
                        String content = voMap.get(vo.getDynmcontId()) + "\r\n" + vo.getDynmcontContent();
                        voMap.put(vo.getDynmcontId(),content);
                    }else{
                        voMap.put(vo.getDynmcontId(),vo.getDynmcontContent());
                    }
                }
            }
        }
        return voMap;
    }
}