package com.thebeastshop.pegasus.merchandise.vo;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;

import pers.richard.ormybatis.domain.core.AbstractDomain;

import com.thebeastshop.scm.po.ProdDynmCont;
import com.thebeastshop.scm.po.ProdDynmCont.ContentType;

public class UpdateProdDynmContVO extends AbstractDomain{
	private Integer prodId;
	private List<String> contentType;
	private List<Integer> sort;	
	private List<String> content;

	public UpdateProdDynmContVO(){}
	
	public List<ProdDynmCont> toProdDynmContList(){
		List<ProdDynmCont> result = new ArrayList<ProdDynmCont>();
		for (int i = 0; i < contentType.size(); i++) {
			ProdDynmCont prodDynmCont = new ProdDynmCont();
			prodDynmCont.setProductId(this.prodId);
			prodDynmCont.setContent(this.index(content, i));
			prodDynmCont.setSort(this.index(sort, i));
			String type = this.index(contentType, i);
			ContentType contentType = ContentType.byType(type);
			prodDynmCont.setContentType(contentType.getType());
			prodDynmCont.setTitleCn(contentType.getNameCn());
			prodDynmCont.setTitleEn(contentType.getNameEn());
			result.add(prodDynmCont);
		}
		return result;
	}
	
	public Integer getProdId() {
		return prodId;
	}
	public void setProdId(Integer prodId) {
		this.prodId = prodId;
	}
	public List<String> getContent() {
		return content;
	}
	public void setContent(List<String> content) {
		this.content = content;
	}
	public List<String> getContentType() {
		return contentType;
	}

	public void setContentType(List<String> contentType) {
		this.contentType = contentType;
	}

	public List<Integer> getSort() {
		return sort;
	}

	public void setSort(List<Integer> sort) {
		this.sort = sort;
	}
	
	private <T> T index(List<T> list, int index) {
		if (CollectionUtils.isEmpty(list)) {
			return null;
		}
		if (list.size() > index) {
			return list.get(index);
		}
		return null;
	}
}