package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.pegasus.merchandise.cond.OpChnCanSaleProdCond;
import com.thebeastshop.pegasus.merchandise.vo.OpChnCanSaleProdVO;
import com.thebeastshop.pegasus.merchandise.vo.OpProductVO;
import com.thebeastshop.pegasus.merchandise.vo.SyncOpChnCanSaleProdVO;
import com.thebeastshop.pegasus.merchandise.vo.UpdateOpChnCanSaleProdVO;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @Author: LK【kai.li@thebeastshop.com】
 * @Date: 2016/9/5 13:26
 */
public interface McOpChnCanSaleProdService {
    List<OpChnCanSaleProdVO> findChannelListByProdIds(List<Long> prodIds);

    List<Long> findProdIdBySkuCode(List<String> skuCodes);

    @Transactional
    Long create(OpChnCanSaleProdVO prod);

    @Transactional
    boolean createList(List<String> channalCode);

    @Transactional
    boolean update(UpdateOpChnCanSaleProdVO prod);


    /**
     *
     * @param prodCode
     *@param chnCode
     * @param onshelf  1-onshelf  0-offshelf   @return
     */
//    boolean updateByProdCodeChnCode(String prodCode, String chnCode, int onshelf);

    /**
     * 根据渠道编码查找
     * @param channelCode  渠道编码
     * @return
     */
    List<OpChnCanSaleProdVO> findByChannelCode(String channelCode);
    @Transactional
    boolean deleteById(Long id);

    /**
     * 根据渠道编码 删除可售SKU
     * @param channelCode
     */
    @Transactional
    void deleteByChannelCode(String channelCode);

    List<OpChnCanSaleProdVO> findByChannelCodeProdId(String channelCode, Long prodId);

    List<OpChnCanSaleProdVO> findByCond(OpChnCanSaleProdCond cond);
    PageQueryResp<OpChnCanSaleProdVO> findByCondByPage(OpChnCanSaleProdCond cond);
    PageQueryResp<OpChnCanSaleProdVO> upDownApprovalByPage(OpChnCanSaleProdCond cond);

    List<OpChnCanSaleProdVO> findByProdIds(List<Long> prodIds);
    List<OpChnCanSaleProdVO> getApprovalCreateUserInfo();

    OpChnCanSaleProdVO findById(Long id);

    void deleteByProdId(Long prodId);

    /**
     * 批量删除产品配置上线渠道
     * @param ids
     * @return boolean
     */
    @Transactional
    boolean rejectOpChnCanSaleProdVO(List<Long> ids);
    List<OpChnCanSaleProdVO> findByIds(List<Long> ids);

    Integer syncChannel(SyncOpChnCanSaleProdVO syncOpChnCanSaleProdVO);

    boolean addChnCanSaleProd(OpProductVO opProductVO);
}
