package com.thebeastshop.pegasus.merchandise.enums;

/**
 * SKU BU 枚举
 */
public enum  PcsSkuBuEnum {
  TBH(1, "TBH"),
  HOME(2, "HOME"),
  MISS_BEAST(3, "MISS BEAST"),
  LITTLE_B(4, "LITTLE B"),
  BlingBling(5, "BlingBling"),
  Naked_Beast(6, "Naked Beast"),
  Buto(7, "Buto"),
  PACKAGING_MATERIAL(8, "包装耗材"),
  ENGINEERING_PROPS(9, "工程道具"),
  Naked_Beast_UW(10, "Naked Beast (UW)");


  /**
   * 通过BU 名称获取 val
   * @param buName
   * @return
   */
  public final static Integer getBuValByName(String buName) {
    if (buName == null) {
      return null;
    }
    for (PcsSkuBuEnum buEnum : PcsSkuBuEnum.values()) {
      if (buName.equals(buEnum.buName)) {
        return buEnum.buVal;
      }
    }
    return null;
  }

  /**
   * 通过BU  val 获取Name
   * @param buVal
   * @return
   */
  public final static String getBuNameByVal(Integer buVal) {
    if (buVal == null) {
      return null;
    }
    for (PcsSkuBuEnum buEnum : PcsSkuBuEnum.values()) {
      if (buVal == buEnum.buVal) {
        return buEnum.buName;
      }
    }
    return null;
  }

  private Integer buVal;
  private String buName;

  PcsSkuBuEnum(Integer buVal, String buName) {
    this.buVal = buVal;
    this.buName = buName;
  }


  public Integer getBuVal() {
    return buVal;
  }

  public String getBuName() {
    return buName;
  }

}
