package com.thebeastshop.pegasus.merchandise.service;

import java.util.List;
import java.util.Map;

import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryCond;
import com.thebeastshop.pegasus.merchandise.cond.PcsSkuCategoryRelationCond;
import com.thebeastshop.pegasus.merchandise.vo.CategoryTreeNodeVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsFrontBackCategoryVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryGmInfo;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryRelationVO;
import com.thebeastshop.pegasus.merchandise.vo.PcsSkuCategoryVO;

/**
 * @author Roy.Chen
 * @update gongjun 2016-08-25
 */
public interface McPcsSkuCategoryService {

    /**
     * 创建品类
     *
     * @param record
     * @return
     */
    Long create(PcsSkuCategoryVO record);


        /**
         * 创建后台品类
         *
         * @param record
         * @return
         */
    Long createBackCategory(PcsSkuCategoryVO record);


    /**
     * 更新品类
     *
     * @param record
     * @return
     */
    boolean update(PcsSkuCategoryVO record);

    /**
     * 更新后台品类
     *
     * @param record
     * @return
     */
    boolean updateBackCategory(PcsSkuCategoryVO record);


    /**
     * 根据主键查找分类,唯一
     *
     * @param id
     * @return
     */
    PcsSkuCategoryVO findById(long id);

    PcsSkuCategoryVO findBackCategoryById(long id);

    public List<PcsSkuCategoryVO> findFrontCategoriesBySkuCode(String skuCode);

    public List<PcsSkuCategoryVO> findBackCategoriesBySkuCode(String skuCode);

    List<PcsSkuCategoryVO> findFrontCategoriesBySkuCodeList(List<String> skuCodeList);

    /**
     * 根据父id查找所有子数据
     *
     * @param parentId
     * @return
     */
    List<PcsSkuCategoryVO> findAllChildrens(long parentId);

    /**
     * 根据父id查找所有后台类目子数据
     *
     * @param parentId
     * @return
     */
    List<PcsSkuCategoryVO> findAllBackCategoryChildrens(long parentId);


    List<PcsSkuCategoryVO> findBackCategoryWithLeaf(Integer leaf,List<Long> parentIds);


    /**
     * 查出所有品类
     *
     * @return
     */
    List<PcsSkuCategoryVO> findAll();
    
    /**
     * 查出所有一级品类
     *
     * @return
     */
    List<PcsSkuCategoryVO> findAllByCode();


    /**
     * 查出所有品类
     *
     * @return
     */
    List<PcsSkuCategoryVO> findAllFrontCategories();



    /**
     * 根据CODE查找品类
     *
     * @param code
     * @return
     */
    PcsSkuCategoryVO findByCode(String code);

    /**
     * 根据名称查找品类
     *
     * @param name
     * @return
     */
    List<PcsSkuCategoryVO> findByName(String name);


    /**
     * 根据名称查找后台品类
     *
     * @param name
     * @return
     */
    List<PcsSkuCategoryVO> findBackCategoryByName(String name);



    /**
     * 根据id集合查找品类
     *
     * @param ids
     * @return
     */
    List<PcsSkuCategoryVO> findByIds(List<Long> ids);


    /**
     * 根据id集合查找后台品类
     *
     * @param ids
     * @return
     */
    List<PcsSkuCategoryVO> findBackCategoriesByIds(List<Long> ids);


    /**
     * 根据code 和 右like code查找分类
     *
     * @param code
     * @return
     */
    List<PcsSkuCategoryVO> findByCodeAndRightLikeCode(String code);



    /**
     * 查找第一层sku品类
     *
     * @return
     */
    List<PcsSkuCategoryVO> findSkuCategoryByParentIdIsNull();

    /**
     * 根据一父ID查找品类
     * @param parentID
     * @return
     */
    PcsSkuCategoryVO findByParentID(Long parentID);

    List<Long> findProductIdsBySkuCodes(List<String> skuCodes);

    List<Long> findProductIdListByCategoryFrontRelationIds(List<Long> ids);

    List<PcsFrontBackCategoryVO> findFrontBackCategoryList(Map<String, Object> params);

    List<PcsSkuCategoryVO> findFrontCategoryList(Map<String, Object> params);

    List<PcsSkuCategoryVO> findBackCategoryList(Map<String, Object> params);

    List<PcsSkuCategoryVO> listPcsSkuCategoryByCond(PcsSkuCategoryCond cond);

    List<PcsSkuCategoryRelationVO> findBackCategoryRelationList(PcsSkuCategoryRelationCond cond);

    void saveOrUpdateBackCategoryRelationList(List<PcsSkuCategoryRelationVO> relationList);

    void saveOrUpdateBackCategoryRelation(PcsSkuCategoryRelationVO relation);

    Integer addFrontCategoryRelation(PcsSkuCategoryRelationVO relation);

    Integer addBackCategoryRelation(PcsSkuCategoryRelationVO relation);

    Integer addFrontBackCategoryRelation(PcsFrontBackCategoryVO frontBackCategoryVO);

    Integer updateBackCategoryRelation(PcsSkuCategoryRelationVO relation);

    void updateSkuCategoryRelation(PcsSkuCategoryRelationVO relation);

    List<PcsSkuCategoryRelationVO> findFrontCategoryRelation(PcsSkuCategoryRelationCond cond);

    List<Long> findFrontCategoryIdListByBackCategoryId(Long backCategoryRelationId);

    List<Long> findFrontCategoryIdListByBackCategoryIds(List<Long> backCategoryRelationIds);

    List<Long> findBackCategoryIdListByFrontCategoryId(Long frontCategoryRelationId);

    Integer countOfFrontCategoryRelation(PcsSkuCategoryRelationCond cond);

    void updateFrontCategoryRelation(PcsSkuCategoryRelationVO relation);

    void deleteFrontCategoryRelationList(List<Long> idList);

    void deleteBackCategoryRelationList(List<Long> idList);

    void synFrontCategoryRelation(String skuCode);

    void saveFrontCategoryRelationByBack(PcsSkuCategoryRelationVO backCategoryRelation);

    void deleteFrontCategoryRelationByBack(PcsSkuCategoryRelationVO backCategoryRelation);

    List<Long> findProductIdsByCategoryFrontRelationIds(List<Long> ids);

    List<PcsSkuCategoryRelationVO> findBackCategoryRelation(PcsSkuCategoryRelationCond cond);

    List<PcsFrontBackCategoryVO> findAllFrontBackCategoryList();

    List<PcsSkuCategoryVO> findAllFrontCategoryList();

    List<PcsSkuCategoryVO> findAllBackCategoryList();
    List<PcsSkuCategoryVO> findAllBackCategoryListIncludeUnUse();

    List<PcsSkuCategoryVO> findAllBackCategoryListByIds(List<Integer> ids);

    List<PcsSkuCategoryVO> findAllFirstBackCategoryList();

    /**
     * 根据skucode查询一级类目和产品名称
     * @param skucodes
     * @return
     */
    Map<String,PcsSkuCategoryVO> findFirstCategoryBySkucodes(List<String> skucodes);

    /**
     * 根据skucode查询一级类目
     * @param skucodes
     * @return
     */
    Map<String,PcsSkuCategoryVO> findFirstCategoryIdBySkucodes(List<String> skucodes);

    PcsSkuCategoryVO findFirstCategoryById(Long id);

    Map<Long,PcsSkuCategoryVO> findFirstCategoryByIds(List<Long> ids);


    List<PcsFrontBackCategoryVO> findRelationBackCategoryByFrontCategoryId(Long frontId);

    //=======================前台品类相关
    /**
     * 创建前台品类
     *
     * @param record
     * @return
     */
    Long createFrontCategory(PcsSkuCategoryVO record);

    /**
     * 更新前台品类
     *
     * @param vo
     * @return
     */
    boolean updateFrontCategory(PcsSkuCategoryVO vo);

    /**
     * 新增前后台对应关系（先删除前台对应的后台类目，再新增前台对应的后台关系）
     * @param frontBackCategoryVO
     * @return
     */
    boolean updateFrontBackCategoryRelationByFrontId(PcsFrontBackCategoryVO frontBackCategoryVO);

    /**
     * 根据类目code查找品牌
     *
     * @param cond
     * @return
     */
    List<Long> findByCondCategory(PcsSkuCategoryCond cond);

    /**
     * 根据类目产品ID查找普通商品的次级类目
     *
     * @param cond
     * @return
     */
    List<PcsSkuCategoryVO> findByCondCategoryCron(PcsSkuCategoryCond cond);


    /**
     * 获取指定类目编号中所有的叶子节点类目编号
     *
     * @param categoryIds 待查找集合
     *
     * @return
     */
    List<Long> listLeafCategoryId(List<Long> categoryIds);

    /**
     * 获取类目树的所有节点
     *
     * @return
     */
    List<CategoryTreeNodeVO> listAllCategoryTreeNode();

    /**
     * 获取指定类目编号所在的类目树所有节点
     *
     * @param ids 类目编号集合
     *
     * @return
     */
    List<CategoryTreeNodeVO> listCategoryTreeNodeByIds(List<Long> ids);

    /**
     * 根据类目产品ID查找普通商品的次级类目
     *
     * @param cond
     * @return
     */
    List<PcsSkuCategoryVO> findCategoryByIds(PcsSkuCategoryCond cond);

    List<PcsSkuCategoryVO> findAllParentFrontCategory();

    /**
     * 根据主类目ID查找普通商品的次级类目
     *
     * @param cond
     * @return
     */
    List<PcsSkuCategoryVO> findCategoryByLeafIds(PcsSkuCategoryCond cond);


    /**
     * 查询品类毛利率
     * @param categoryId
     * @return
     */
    PcsSkuCategoryGmInfo findGmByCategoryId(Integer categoryId);
    
    /**
     * 查询sku 所对应的类目
     * @Methods Name findBackCategoryBySkuCodes
     * @Create In 2017-11-2 By Xiang.Gao
     * @param skuCodes
     * @return Map<String,List<PcsSkuCategoryVO>>
     */
    Map<String, List<PcsSkuCategoryVO>> findBackCategoryBySkuCodes(List<String> skuCodes);

    /**
     * 查找所有启用的后台类目
     *
     * @return
     */
    List<PcsSkuCategoryVO> findAllInUseBackCategoryList();
    
    void saveOfUpdateBackCategories(String skuCode, List<Long> categoryIds);

    /**
     * 根据等级查询所有启用的后台类目
     *
     * @return
     */
    List<PcsSkuCategoryVO> findAllInUseBackCategoryListByLevel(List<Integer> level);
}