package com.thebeastshop.pegasus.merchandise.service;


import com.thebeastshop.pegasus.merchandise.vo.*;

import java.util.List;

public interface McOpProdDynmcontDetailsService {
    
	/**
	 * 通过商品code查询redis缓存动态内容数据
	 * @param productCode
	 * @return
	 */
	OpProdDynmDetailsSaveVO getByProductCode(String productCode);
    
	List<OpProdDynmDetailsVO> findByProdId(Long prodId);
	List<OpProdDynmDetailsVO> findByProdCode(String prodCode);
	List<OpProdDynmDetailsVO> findDistinctProductCode();
	List<OpProdDynmDetailsInsertVO> findDynmDetailsInsertVOByProdCode(String prodCode);
	List<PsDynmContentVO> findOldDyncByProdId(Long prodId);
	
	/**
	 * 根据prodId查询SKUCODE
	 * @param prodId
	 * @return
	 */
	List<ProdSkuVO> findProdSkuByProdId(Long prodId);
	
	/**
	 * 批量导入动态内容
	 * @param prodCode
     * @param productId
     * @param content
     * @param contentTypeIndex
	 */
	void saveByProdCodeAndTypeNew(String prodCode,Integer productId, String content, Integer contentTypeIndex);
	
	/**
	 * 是否编辑过新版
	 * @param productCode
	 * @return
	 */
	boolean IsEditByProdCode(String productCode);


	Integer batchUpdateProd (List<OpProdDynmDetailsInsertVO> opProdDynmDetails,OpProdDynmDetailsSaveVO opProdDynmDetailsSaveVO);
	Integer batchUpdateProd (List<OpProdDynmDetailsInsertVO> opProdDynmDetails,OpProdDynmDetailsSaveVO opProdDynmDetailsSaveVO,Boolean isOldDelete,Integer createId,String createMan);

	Integer batchDeleteByProdId (Integer prodId);

    /**
     * 批量更新商品动态内容
     *
     * @param paramList 待更新列表
     *
     */
	Integer batchUpdateDynamicContent(List<OpProdDynmDetailsInsertVO> paramList);
	Integer batchUpdateDynamicContent(List<OpProdDynmDetailsInsertVO> paramList,Integer createId,String createMan);
	Integer batchUpdateDynamicContent(List<OpProdDynmDetailsInsertVO> paramList,Integer createId,String createMan,Boolean isCopy);

}
